/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class ArrayRemove
extends ExtensionFunctionDefinition {
    private static final StructuredQName name = new StructuredQName("array", "http://www.w3.org/2005/xpath-functions/array", "remove");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{ArrayItem.SINGLE_ARRAY_TYPE, SequenceType.SINGLE_INTEGER};

    public StructuredQName getFunctionQName() {
        return name;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return ArrayItem.SINGLE_ARRAY_TYPE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                ArrayItem array = (ArrayItem)arguments[0].head();
                assert (array != null);
                int index = (int)((IntegerValue)arguments[1].head()).longValue() - 1;
                if (index < 0 || index >= array.size()) {
                    throw new XPathException("Position is not in range", "FOAY0001");
                }
                return array.remove(index);
            }
        };
    }
}

