/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;

public class DocumentNodeTest
extends NodeTest {
    private NodeTest elementTest;

    public DocumentNodeTest(NodeTest elementTest) {
        this.elementTest = elementTest;
    }

    public UType getUType() {
        return UType.DOCUMENT;
    }

    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        throw new UnsupportedOperationException("DocumentNodeTest doesn't support this method");
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        if (tree.getNodeKind(nodeNr) != 9) {
            return false;
        }
        return this.matchesNode(tree.getNode(nodeNr));
    }

    public boolean matchesNode(NodeInfo node) {
        if (node.getNodeKind() != 9) {
            return false;
        }
        AxisIterator iter = node.iterateAxis((byte)3);
        boolean found = false;
        while (true) {
            NodeInfo n;
            if ((n = iter.next()) == null) {
                return found;
            }
            int kind = n.getNodeKind();
            if (kind == 3) {
                return false;
            }
            if (kind != 1) continue;
            if (found) {
                return false;
            }
            if (!this.elementTest.matchesNode(n)) break;
            found = true;
        }
        return false;
    }

    public final double getDefaultPriority() {
        return this.elementTest.getDefaultPriority();
    }

    public int getPrimitiveType() {
        return 9;
    }

    public int getNodeKindMask() {
        return 512;
    }

    public NodeTest getElementTest() {
        return this.elementTest;
    }

    public String toString() {
        return "document-node(" + this.elementTest.toString() + ')';
    }

    public int hashCode() {
        return this.elementTest.hashCode() ^ 0x3039;
    }

    public boolean equals(Object other) {
        return other instanceof DocumentNodeTest && ((DocumentNodeTest)other).elementTest.equals(this.elementTest);
    }

    public String generateJavaScriptItemTypeTest(ItemType knownToBe) throws XPathException {
        String elTest = "function e(item) {" + this.elementTest.generateJavaScriptItemTypeTest(NodeKindTest.ELEMENT) + "};";
        return elTest + "return item instanceof Node && (item.nodeType==9 || item.nodeType==11) && " + "SaxonJS.Axis.child(item).filter(e).next();";
    }
}

