/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.ComponentBinding;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.BooleanExpressionPattern;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternWithPredicate;
import net.sf.saxon.pattern.UniversalPattern;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.BuiltInRuleSet;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.RuleSearchState;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.TextOnlyCopyRuleSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMode
extends Mode {
    protected Rule genericRuleChain = null;
    protected Rule atomicValueRuleChain = null;
    protected Rule functionItemRuleChain = null;
    protected Rule documentRuleChain = null;
    protected Rule textRuleChain = null;
    protected Rule commentRuleChain = null;
    protected Rule processingInstructionRuleChain = null;
    protected Rule namespaceRuleChain = null;
    protected Rule unnamedElementRuleChain = null;
    protected Rule unnamedAttributeRuleChain = null;
    protected IntHashMap<Rule> namedElementRuleChains = new IntHashMap(32);
    protected IntHashMap<Rule> namedAttributeRuleChains = new IntHashMap(8);
    protected Map<StructuredQName, Rule> qNamedElementRuleChains;
    protected Map<StructuredQName, Rule> qNamedAttributeRuleChains;
    private BuiltInRuleSet builtInRuleSet = TextOnlyCopyRuleSet.getInstance();
    private Rule mostRecentRule;
    private int mostRecentModuleHash;
    private int stackFrameSlotsNeeded = 0;
    private int highestRank;
    private Map<String, Integer> explicitPropertyPrecedences = new HashMap<String, Integer>();
    private Map<String, String> explicitPropertyValues = new HashMap<String, String>();

    public SimpleMode(StructuredQName modeName) {
        super(modeName);
    }

    public void setBuiltInRuleSet(BuiltInRuleSet defaultRules) {
        this.builtInRuleSet = defaultRules;
        this.hasRules = true;
    }

    @Override
    public BuiltInRuleSet getBuiltInRuleSet() {
        return this.builtInRuleSet;
    }

    @Override
    public SimpleMode getActivePart() {
        return this;
    }

    public void checkForConflictingProperties() throws XPathException {
        String typed = this.explicitPropertyValues.get("typed");
        this.mustBeTyped = "yes".equals(typed) || "strict".equals(typed) || "lax".equals(typed);
        this.mustBeUntyped = "no".equals(typed);
        for (Map.Entry<String, String> entry : this.getActivePart().explicitPropertyValues.entrySet()) {
            if (!entry.getValue().equals("##conflict##")) continue;
            throw new XPathException("There are conflicting values for xsl:mode/@" + entry.getKey() + " at the same import precedence", "XTSE0545");
        }
    }

    public static void copyRules(SimpleMode from, final SimpleMode to) {
        try {
            from.processRules(new Mode.RuleAction(){

                public void processRule(Rule r) throws XPathException {
                    Rule r2 = new Rule(r, false);
                    to.addRule(r2.pattern, r2);
                }
            });
        }
        catch (XPathException e) {
            throw new AssertionError((Object)e);
        }
        to.mostRecentRule = from.mostRecentRule;
        to.mostRecentModuleHash = from.mostRecentModuleHash;
    }

    protected RuleSearchState makeRuleSearchState() {
        return new RuleSearchState(this);
    }

    @Override
    public boolean isEmpty() {
        return !this.hasRules;
    }

    public void setExplicitProperty(String name, String value, int precedence) {
        Integer p = this.explicitPropertyPrecedences.get(name);
        if (p != null) {
            String v;
            if (p != null && p < precedence) {
                this.explicitPropertyPrecedences.put(name, precedence);
                this.explicitPropertyValues.put(name, value);
            } else if (p != null && p == precedence && (v = this.explicitPropertyValues.get(name)) != null & !v.equals(value)) {
                this.explicitPropertyValues.put(name, "##conflict##");
            }
        } else {
            this.explicitPropertyPrecedences.put(name, precedence);
            this.explicitPropertyValues.put(name, value);
        }
        String typed = this.explicitPropertyValues.get("typed");
        this.mustBeTyped = "yes".equals(typed) || "strict".equals(typed) || "lax".equals(typed);
        this.mustBeUntyped = "no".equals(typed);
    }

    public String getPropertyValue(String name) {
        return this.explicitPropertyValues.get(name);
    }

    @Override
    public Set<String> getExplicitNamespaces(NamePool pool) {
        HashSet<String> namespaces = new HashSet<String>();
        IntIterator ii = this.namedElementRuleChains.keyIterator();
        while (ii.hasNext()) {
            int fp = ii.next();
            namespaces.add(pool.getURI(fp));
        }
        return namespaces;
    }

    public void addRule(Pattern pattern, RuleTarget action, StylesheetModule module, int precedence, double priority, boolean explicitMode) {
        if (explicitMode) {
            this.hasRules = true;
        }
        if (pattern.getItemType() instanceof ErrorType) {
            return;
        }
        int moduleHash = module.hashCode();
        int sequence = this.mostRecentRule == null ? 0 : (action == this.mostRecentRule.getAction() && moduleHash == this.mostRecentModuleHash ? this.mostRecentRule.getSequence() : this.mostRecentRule.getSequence() + 1);
        int minImportPrecedence = module.getMinImportPrecedence();
        Rule newRule = this.makeRule(pattern, action, precedence, minImportPrecedence, priority, sequence);
        if (pattern instanceof NodeTestPattern) {
            int kind;
            ItemType test = pattern.getItemType();
            if (test instanceof AnyNodeTest) {
                newRule.setAlwaysMatches(true);
            } else if (test instanceof NodeKindTest) {
                newRule.setAlwaysMatches(true);
            } else if (test instanceof NameTest && ((kind = test.getPrimitiveType()) == 1 || kind == 2)) {
                newRule.setAlwaysMatches(true);
            }
        }
        this.mostRecentRule = newRule;
        this.mostRecentModuleHash = moduleHash;
        this.addRule(pattern, newRule);
    }

    public Rule makeRule(Pattern pattern, RuleTarget action, int precedence, int minImportPrecedence, double priority, int sequence) {
        return new Rule(pattern, action, precedence, minImportPrecedence, priority, sequence);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRule(Pattern pattern, Rule newRule) {
        UType uType = pattern.getUType();
        if (uType.equals(UType.ELEMENT)) {
            int fp = pattern.getFingerprint();
            if (fp == -1) {
                this.unnamedElementRuleChain = this.addRuleToList(newRule, this.unnamedElementRuleChain);
                return;
            } else {
                Rule chain = this.namedElementRuleChains.get(fp);
                this.namedElementRuleChains.put(fp, this.addRuleToList(newRule, chain));
            }
            return;
        } else if (uType.equals(UType.ATTRIBUTE)) {
            int fp = pattern.getFingerprint();
            if (fp == -1) {
                this.unnamedAttributeRuleChain = this.addRuleToList(newRule, this.unnamedAttributeRuleChain);
                return;
            } else {
                Rule chain = this.namedAttributeRuleChains.get(fp);
                this.namedAttributeRuleChains.put(fp, this.addRuleToList(newRule, chain));
            }
            return;
        } else if (uType.equals(UType.DOCUMENT)) {
            this.documentRuleChain = this.addRuleToList(newRule, this.documentRuleChain);
            return;
        } else if (uType.equals(UType.TEXT)) {
            this.textRuleChain = this.addRuleToList(newRule, this.textRuleChain);
            return;
        } else if (uType.equals(UType.COMMENT)) {
            this.commentRuleChain = this.addRuleToList(newRule, this.commentRuleChain);
            return;
        } else if (uType.equals(UType.PI)) {
            this.processingInstructionRuleChain = this.addRuleToList(newRule, this.processingInstructionRuleChain);
            return;
        } else if (uType.equals(UType.NAMESPACE)) {
            this.namespaceRuleChain = this.addRuleToList(newRule, this.namespaceRuleChain);
            return;
        } else if (UType.ANY_NODE.subsumes(uType)) {
            this.genericRuleChain = this.addRuleToList(newRule, this.genericRuleChain);
            return;
        } else if (pattern instanceof NodeTestPattern || pattern instanceof PatternWithPredicate) {
            ItemType type = pattern.getItemType();
            if (type instanceof AtomicType) {
                this.atomicValueRuleChain = this.addRuleToList(newRule, this.atomicValueRuleChain);
                return;
            } else {
                if (!(type instanceof FunctionItemType)) throw new UnsupportedOperationException("XSLT 3.0 '.[]' syntax not recognized with node type or external object types");
                this.functionItemRuleChain = this.addRuleToList(newRule, this.functionItemRuleChain);
            }
            return;
        } else {
            if (!(pattern instanceof BooleanExpressionPattern) && !(pattern instanceof UniversalPattern)) throw new UnsupportedOperationException("Unrecognized pattern " + pattern.getClass());
            this.genericRuleChain = this.addRuleToList(newRule, this.genericRuleChain);
        }
    }

    private Rule addRuleToList(Rule newRule, Rule list) {
        Rule rule;
        if (list == null) {
            return newRule;
        }
        int precedence = newRule.getPrecedence();
        double priority = newRule.getPriority();
        Rule prev = null;
        for (rule = list; rule != null; rule = rule.getNext()) {
            if (rule.getPrecedence() < precedence || rule.getPrecedence() == precedence && rule.getPriority() <= priority) {
                newRule.setNext(rule);
                if (prev == null) {
                    return newRule;
                }
                prev.setNext(newRule);
                break;
            }
            prev = rule;
        }
        if (rule == null) {
            prev.setNext(newRule);
            newRule.setNext(null);
        }
        return list;
    }

    public void allocatePatternSlots(int slots) {
        this.stackFrameSlotsNeeded = Math.max(this.stackFrameSlotsNeeded, slots);
    }

    @Override
    public Rule getRule(Item item, XPathContext context) throws XPathException {
        if (this.stackFrameSlotsNeeded > 0) {
            context = this.makeNewContext(context);
        }
        RuleSearchState ruleSearchState = this.makeRuleSearchState();
        Rule bestRule = null;
        if (item instanceof NodeInfo) {
            Rule unnamedNodeChain;
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    unnamedNodeChain = this.documentRuleChain;
                    break;
                }
                case 1: {
                    unnamedNodeChain = this.unnamedElementRuleChain;
                    Rule namedNodeChain = node instanceof FingerprintedNode ? this.namedElementRuleChains.get(((FingerprintedNode)node).getFingerprint()) : this.getNamedRuleChain(context, 1, node.getURI(), node.getLocalPart());
                    if (namedNodeChain == null) break;
                    bestRule = this.searchRuleChain(node, context, null, namedNodeChain, ruleSearchState);
                    break;
                }
                case 2: {
                    unnamedNodeChain = this.unnamedAttributeRuleChain;
                    Rule namedNodeChain = node instanceof FingerprintedNode ? this.namedAttributeRuleChains.get(((FingerprintedNode)node).getFingerprint()) : this.getNamedRuleChain(context, 2, node.getURI(), node.getLocalPart());
                    if (namedNodeChain == null) break;
                    bestRule = this.searchRuleChain(node, context, null, namedNodeChain, ruleSearchState);
                    break;
                }
                case 3: {
                    unnamedNodeChain = this.textRuleChain;
                    break;
                }
                case 8: {
                    unnamedNodeChain = this.commentRuleChain;
                    break;
                }
                case 7: {
                    unnamedNodeChain = this.processingInstructionRuleChain;
                    break;
                }
                case 13: {
                    unnamedNodeChain = this.namespaceRuleChain;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unknown node kind");
                }
            }
            if (unnamedNodeChain != null) {
                bestRule = this.searchRuleChain(node, context, bestRule, unnamedNodeChain, ruleSearchState);
            }
            if (this.genericRuleChain != null) {
                bestRule = this.searchRuleChain(node, context, bestRule, this.genericRuleChain, ruleSearchState);
            }
        } else if (item instanceof AtomicValue) {
            if (this.atomicValueRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.atomicValueRuleChain, ruleSearchState);
            }
            if (this.genericRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.genericRuleChain, ruleSearchState);
            }
        } else if (item instanceof Function) {
            if (this.functionItemRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.functionItemRuleChain, ruleSearchState);
            }
            if (this.genericRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.genericRuleChain, ruleSearchState);
            }
        }
        return bestRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Rule getNamedRuleChain(XPathContext c, int kind, String uri, String local) {
        if (this.qNamedElementRuleChains == null) {
            SimpleMode simpleMode = this;
            synchronized (simpleMode) {
                this.qNamedElementRuleChains = new HashMap<StructuredQName, Rule>(this.namedElementRuleChains.size());
                this.qNamedAttributeRuleChains = new HashMap<StructuredQName, Rule>(this.namedAttributeRuleChains.size());
                NamePool pool = c.getNamePool();
                IntIterator eIter = this.namedElementRuleChains.keyIterator();
                while (eIter.hasNext()) {
                    int fp = eIter.next();
                    Rule eChain = this.namedElementRuleChains.get(fp);
                    StructuredQName name = pool.getStructuredQName(fp);
                    this.qNamedElementRuleChains.put(name, eChain);
                }
                IntIterator aIter = this.namedAttributeRuleChains.keyIterator();
                while (aIter.hasNext()) {
                    int fp = aIter.next();
                    Rule eChain = this.namedAttributeRuleChains.get(fp);
                    StructuredQName name = pool.getStructuredQName(fp);
                    this.qNamedAttributeRuleChains.put(name, eChain);
                }
            }
        }
        return (kind == 1 ? this.qNamedElementRuleChains : this.qNamedAttributeRuleChains).get(new StructuredQName("", uri, local));
    }

    protected Rule searchRuleChain(Item item, XPathContext context, Rule bestRule, Rule head, RuleSearchState ruleSearchState) throws XPathException {
        while (!(context instanceof XPathContextMajor)) {
            context = context.getCaller();
        }
        while (head != null) {
            block7: {
                block5: {
                    block6: {
                        if (bestRule == null) break block5;
                        int rank = head.compareRank(bestRule);
                        if (rank < 0) break;
                        if (rank != 0) break block6;
                        if (this.ruleMatches(head, item, (XPathContextMajor)context, ruleSearchState)) {
                            this.reportAmbiguity(item, bestRule, head, context);
                            bestRule = bestRule.getSequence() > head.getSequence() ? bestRule : head;
                            break;
                        }
                        break block7;
                    }
                    if (!this.ruleMatches(head, item, (XPathContextMajor)context, ruleSearchState)) break block7;
                    bestRule = head;
                    break block7;
                }
                if (this.ruleMatches(head, item, (XPathContextMajor)context, ruleSearchState)) {
                    bestRule = head;
                    if (this.getRecoveryPolicy() == 0) {
                        ruleSearchState.count();
                        break;
                    }
                }
            }
            ruleSearchState.count();
            head = head.getNext();
        }
        return bestRule;
    }

    protected boolean ruleMatches(Rule r, Item item, XPathContextMajor context, RuleSearchState pre) throws XPathException {
        return r.isAlwaysMatches() || r.matches(item, context);
    }

    @Override
    public Rule getRule(Item item, XPathContext context, Mode.RuleFilter filter) throws XPathException {
        if (this.stackFrameSlotsNeeded > 0) {
            context = this.makeNewContext(context);
        }
        RuleSearchState ruleSearchState = this.makeRuleSearchState();
        Rule bestRule = null;
        if (item instanceof NodeInfo) {
            Rule unnamedNodeChain;
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    unnamedNodeChain = this.documentRuleChain;
                    break;
                }
                case 1: {
                    unnamedNodeChain = this.unnamedElementRuleChain;
                    Rule namedNodeChain = node instanceof FingerprintedNode ? this.namedElementRuleChains.get(((FingerprintedNode)node).getFingerprint()) : this.getNamedRuleChain(context, 1, node.getURI(), node.getLocalPart());
                    bestRule = this.searchRuleChain(item, context, null, namedNodeChain, ruleSearchState, filter);
                    break;
                }
                case 2: {
                    unnamedNodeChain = this.unnamedAttributeRuleChain;
                    Rule namedNodeChain = node instanceof FingerprintedNode ? this.namedAttributeRuleChains.get(((FingerprintedNode)node).getFingerprint()) : this.getNamedRuleChain(context, 2, node.getURI(), node.getLocalPart());
                    bestRule = this.searchRuleChain(item, context, null, namedNodeChain, ruleSearchState, filter);
                    break;
                }
                case 3: {
                    unnamedNodeChain = this.textRuleChain;
                    break;
                }
                case 8: {
                    unnamedNodeChain = this.commentRuleChain;
                    break;
                }
                case 7: {
                    unnamedNodeChain = this.processingInstructionRuleChain;
                    break;
                }
                case 13: {
                    unnamedNodeChain = this.namespaceRuleChain;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unknown node kind");
                }
            }
            bestRule = this.searchRuleChain(item, context, bestRule, unnamedNodeChain, ruleSearchState, filter);
            return this.searchRuleChain(item, context, bestRule, this.genericRuleChain, ruleSearchState, filter);
        }
        if (item instanceof AtomicValue) {
            if (this.atomicValueRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.atomicValueRuleChain, ruleSearchState, filter);
            }
            if (this.genericRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.genericRuleChain, ruleSearchState, filter);
            }
            return bestRule;
        }
        if (item instanceof Function) {
            if (this.functionItemRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.functionItemRuleChain, ruleSearchState, filter);
            }
            if (this.genericRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.genericRuleChain, ruleSearchState, filter);
            }
            return bestRule;
        }
        return null;
    }

    protected Rule searchRuleChain(Item item, XPathContext context, Rule bestRule, Rule head, RuleSearchState ruleSearchState, Mode.RuleFilter filter) throws XPathException {
        while (!(context instanceof XPathContextMajor)) {
            context = context.getCaller();
        }
        while (head != null) {
            if (filter == null || filter.testRule(head)) {
                if (bestRule != null) {
                    int rank = head.compareRank(bestRule);
                    if (rank < 0) break;
                    if (rank == 0) {
                        if (this.ruleMatches(head, item, (XPathContextMajor)context, ruleSearchState)) {
                            this.reportAmbiguity(item, bestRule, head, context);
                            bestRule = bestRule.getSequence() > head.getSequence() ? bestRule : head;
                            break;
                        }
                    } else if (this.ruleMatches(head, item, (XPathContextMajor)context, ruleSearchState)) {
                        bestRule = head;
                    }
                } else if (this.ruleMatches(head, item, (XPathContextMajor)context, ruleSearchState)) {
                    bestRule = head;
                    if (this.getRecoveryPolicy() == 0) break;
                }
            }
            head = head.getNext();
        }
        return bestRule;
    }

    protected void reportAmbiguity(Item item, Rule r1, Rule r2, XPathContext c) throws XPathException {
        if (r1.getAction() == r2.getAction() && r1.getSequence() == r2.getSequence()) {
            return;
        }
        String errorCode = c.getController().getExecutable().isAllowXPath30() ? "XTDE0540" : "XTRE0540";
        String path = item instanceof NodeInfo ? Navigator.getPath((NodeInfo)item) : item.getStringValue();
        Pattern pat1 = r1.getPattern();
        Pattern pat2 = r2.getPattern();
        String message = r1.getAction() == r2.getAction() ? "Ambiguous rule match for " + path + ". " + "Matches \"" + SimpleMode.showPattern(pat1) + "\" on line " + pat1.getLocation().getLineNumber() + " of " + pat1.getSystemId() + ", a rule which appears in the stylesheet more than once, because the containing module was included more than once" : "Ambiguous rule match for " + path + '\n' + "Matches both \"" + SimpleMode.showPattern(pat1) + "\" on line " + pat1.getLocation().getLineNumber() + " of " + pat1.getSystemId() + "\nand \"" + SimpleMode.showPattern(pat2) + "\" on line " + pat2.getLocation().getLineNumber() + " of " + pat2.getSystemId();
        XPathException err = new XPathException(message, errorCode);
        if (this.getRecoveryPolicy() == 2) {
            throw err;
        }
        c.getController().recoverableError(err);
    }

    private static String showPattern(Pattern p) {
        return Whitespace.collapseWhitespace(p.toString()).toString();
    }

    public void prepareStreamability() throws XPathException {
    }

    @Override
    public void allocateAllBindingSlots(StylesheetPackage pack) {
        if (this.getDeclaringComponent().getDeclaringPackage() == pack) {
            SimpleMode.forceAllocateAllBindingSlots(pack, this, this.getDeclaringComponent().getComponentBindings());
        }
    }

    public static void forceAllocateAllBindingSlots(final StylesheetPackage pack, final SimpleMode mode, final List<ComponentBinding> bindings) {
        try {
            mode.processRules(new Mode.RuleAction(){

                public void processRule(Rule r) {
                    SimpleMode.allocateBindingSlotsRecursive(pack, mode, r.getPattern(), bindings);
                    SimpleMode.allocateBindingSlotsRecursive(pack, mode, ((TemplateRule)r.getAction()).getBody(), bindings);
                }
            });
        }
        catch (XPathException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void computeStreamability() throws XPathException {
    }

    public void invertStreamableTemplates() throws XPathException {
    }

    @Override
    public void explainTemplateRules(final ExpressionPresenter out) throws XPathException {
        Mode.RuleAction action = new Mode.RuleAction(){

            public void processRule(Rule r) throws XPathException {
                r.export(out, SimpleMode.this.isDeclaredStreamable());
            }
        };
        RuleGroupAction group = new RuleGroupAction(){
            String type;

            public void start() {
                out.startElement("ruleSet");
                out.emitAttribute("type", this.type);
            }

            public void setString(String type) {
                this.type = type;
            }

            public void start(int i) {
                out.startElement("ruleChain");
                out.emitAttribute("key", out.getNamePool().getClarkName(i));
            }

            public void end() {
                out.endElement();
            }
        };
        try {
            this.processRules(action, group);
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    @Override
    public void exportTemplateRules(final ExpressionPresenter out) throws XPathException {
        Mode.RuleAction action = new Mode.RuleAction(){

            public void processRule(Rule r) throws XPathException {
                r.export(out, SimpleMode.this.isDeclaredStreamable());
            }
        };
        this.processRules(action);
    }

    @Override
    public void processRules(Mode.RuleAction action) throws XPathException {
        this.processRules(action, null);
    }

    public void processRules(Mode.RuleAction action, RuleGroupAction group) throws XPathException {
        this.processRuleChain(this.documentRuleChain, action, this.setGroup(group, "document-node()"));
        this.processRuleChain(this.unnamedElementRuleChain, action, this.setGroup(group, "element()"));
        this.processRuleChains(this.namedElementRuleChains, action, this.setGroup(group, "namedElements"));
        this.processRuleChain(this.unnamedAttributeRuleChain, action, this.setGroup(group, "attribute()"));
        this.processRuleChains(this.namedAttributeRuleChains, action, this.setGroup(group, "namedAttributes"));
        this.processRuleChain(this.textRuleChain, action, this.setGroup(group, "text()"));
        this.processRuleChain(this.commentRuleChain, action, this.setGroup(group, "comment()"));
        this.processRuleChain(this.processingInstructionRuleChain, action, this.setGroup(group, "processing-instruction()"));
        this.processRuleChain(this.namespaceRuleChain, action, this.setGroup(group, "namespace()"));
        this.processRuleChain(this.genericRuleChain, action, this.setGroup(group, "node()"));
        this.processRuleChain(this.atomicValueRuleChain, action, this.setGroup(group, "atomicValue"));
        this.processRuleChain(this.functionItemRuleChain, action, this.setGroup(group, "function()"));
    }

    protected RuleGroupAction setGroup(RuleGroupAction group, String type) {
        if (group != null) {
            group.setString(type);
        }
        return group;
    }

    public void processRuleChains(IntHashMap<Rule> chains, Mode.RuleAction action, RuleGroupAction group) throws XPathException {
        if (chains.size() > 0) {
            if (group != null) {
                group.start();
            }
            IntIterator ii = chains.keyIterator();
            while (ii.hasNext()) {
                int i = ii.next();
                if (group != null) {
                    group.start(i);
                }
                Rule r = chains.get(i);
                this.processRuleChain(r, action, null);
                if (group == null) continue;
                group.end();
            }
            if (group != null) {
                group.end();
            }
        }
    }

    public void processRuleChain(Rule r, Mode.RuleAction action) throws XPathException {
        while (r != null) {
            action.processRule(r);
            r = r.getNext();
        }
    }

    public void processRuleChain(Rule r, Mode.RuleAction action, RuleGroupAction group) throws XPathException {
        if (r != null) {
            if (group != null) {
                group.start();
            }
            while (r != null) {
                action.processRule(r);
                r = r.getNext();
            }
            if (group != null) {
                group.end();
            }
        }
    }

    public void optimizeRules() {
    }

    @Override
    public int getMaxPrecedence() {
        try {
            MaxPrecedenceAction action = new MaxPrecedenceAction();
            this.processRules(action);
            return action.max;
        }
        catch (XPathException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void computeRankings(int start) throws XPathException {
        final RuleSorter sorter = new RuleSorter(start);
        Mode.RuleAction addToSorter = new Mode.RuleAction(){

            public void processRule(Rule r) {
                sorter.addRule(r);
            }
        };
        this.processRules(addToSorter);
        sorter.allocateRanks();
        this.highestRank = start + sorter.getNumberOfRules();
    }

    @Override
    public int getMaxRank() {
        return this.highestRank;
    }

    public void allocateAllPatternSlots() throws XPathException {
        final ArrayList<Integer> count = new ArrayList<Integer>(1);
        count.add(0);
        final SlotManager slotManager = new SlotManager();
        Mode.RuleAction slotAllocator = new Mode.RuleAction(){

            public void processRule(Rule r) throws XPathException {
                int slots = r.getPattern().allocateSlots(slotManager, 0);
                int max = Math.max((Integer)count.get(0), slots);
                count.set(0, max);
            }
        };
        this.processRules(slotAllocator);
        this.stackFrameSlotsNeeded = (Integer)count.get(0);
    }

    @Override
    public int getStackFrameSlotsNeeded() {
        return this.stackFrameSlotsNeeded;
    }

    public void setStackFrameSlotsNeeded(int slots) {
        this.stackFrameSlotsNeeded = slots;
    }

    public static interface RuleGroupAction {
        public void setString(String var1);

        public void start();

        public void start(int var1) throws XPathException;

        public void end() throws XPathException;
    }

    private static class RuleSorter
    implements Sortable {
        public ArrayList<Rule> rules = new ArrayList(100);
        private int start;

        public RuleSorter(int start) {
            this.start = start;
        }

        public void addRule(Rule rule) {
            this.rules.add(rule);
        }

        public int compare(int a, int b) {
            return this.rules.get(a).compareComputedRank(this.rules.get(b));
        }

        public void swap(int a, int b) {
            Rule temp = this.rules.get(a);
            this.rules.set(a, this.rules.get(b));
            this.rules.set(b, temp);
        }

        public void allocateRanks() {
            GenericSorter.quickSort(0, this.rules.size(), this);
            int rank = this.start;
            for (int i = 0; i < this.rules.size(); ++i) {
                if (i > 0 && this.rules.get(i - 1).compareComputedRank(this.rules.get(i)) != 0) {
                    ++rank;
                }
                this.rules.get(i).setRank(rank);
            }
        }

        public int getNumberOfRules() {
            return this.rules.size();
        }
    }

    private static class MaxPrecedenceAction
    implements Mode.RuleAction {
        public int max = 0;

        private MaxPrecedenceAction() {
        }

        public void processRule(Rule r) {
            if (r.precedence > this.max) {
                this.max = r.precedence;
            }
        }
    }
}

