/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.instruct.LocalParamSetter;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.GlobalVariableManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class PromotionOffer {
    public static final int FOCUS_INDEPENDENT = 10;
    public static final int RANGE_INDEPENDENT = 11;
    public static final int EXTRACT_GLOBAL_VARIABLES = 14;
    private Optimizer optimizer;
    public ExpressionVisitor visitor;
    public int action;
    public boolean promoteDocumentDependent = false;
    public boolean promoteXSLTFunctions = true;
    public GlobalVariableManager globalVariableManager;
    public Binding[] bindingList;
    public Expression containingExpression;
    public boolean accepted = false;

    public PromotionOffer(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Expression accept(Expression child) throws XPathException {
        switch (this.action) {
            case 11: {
                int properties = child.getSpecialProperties();
                if ((properties & 0x400000) == 0 || ExpressionTool.dependsOnVariable(child, this.bindingList) || (child.getDependencies() & 0x1000200) != 0) break;
                return this.promote(child);
            }
            case 10: {
                int dependencies = child.getDependencies();
                int properties = child.getSpecialProperties();
                if (!this.promoteXSLTFunctions && (dependencies & 0x261) != 0 || (dependencies & 0x1000200) != 0) break;
                if ((dependencies & 0x1E) == 0 && (properties & 0x400000) != 0 && !ExpressionTool.dependsOnVariable(child, this.bindingList)) {
                    return this.promote(child);
                }
                if (!this.promoteDocumentDependent || (dependencies & 0xE) != 0 || (properties & 0x400000) == 0 || ExpressionTool.dependsOnVariable(child, this.bindingList)) break;
                return this.promote(child);
            }
            case 14: {
                if (child instanceof Literal || child instanceof LocalParamSetter || child == this.containingExpression || (child.getDependencies() & 0xFFFFFBFF) != 0 || (child.getSpecialProperties() & 0x400000) == 0 || (child.getSpecialProperties() & 0x1000000) != 0) break;
                return this.optimizer.extractGlobalVariables(child, this.visitor, this);
            }
            default: {
                throw new UnsupportedOperationException("Unknown promotion action " + this.action);
            }
        }
        return null;
    }

    private Expression promote(Expression child) {
        boolean indexed = false;
        Expression parent = child.getParentExpression();
        if (parent instanceof GeneralComparison && ((GeneralComparison)parent).getOperator() == 6) {
            indexed = true;
        }
        LetExpression let = new LetExpression();
        let.setVariableQName(new StructuredQName("vv", "http://saxon.sf.net/generated-variable", "loc" + let.hashCode()));
        SequenceType type = SequenceType.makeSequenceType(child.getItemType(), child.getCardinality());
        let.setRequiredType(type);
        ExpressionTool.copyLocationInfo(this.containingExpression, let);
        let.setSequence(child);
        let.setEvaluationMode(Cardinality.allowsMany(child.getCardinality()) ? 4 : 13);
        let.setAction(this.containingExpression);
        let.adoptChildExpression(this.containingExpression);
        if (indexed) {
            let.setIndexedVariable();
        }
        this.containingExpression = let;
        this.accepted = true;
        LocalVariableReference var = new LocalVariableReference(let);
        int properties = child.getSpecialProperties() & 0x2000000;
        var.setStaticType(type, null, properties);
        let.addReference(var, true);
        ExpressionTool.copyLocationInfo(this.containingExpression, var);
        return var;
    }
}

