/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public class XPathEvaluator {
    private XPathStaticContext staticContext;

    public XPathEvaluator() {
        this(new Configuration());
    }

    public XPathEvaluator(Configuration config) {
        this.staticContext = new IndependentContext(config);
    }

    public Configuration getConfiguration() {
        return this.staticContext.getConfiguration();
    }

    public void setStaticContext(XPathStaticContext context) {
        this.staticContext = context;
    }

    public XPathStaticContext getStaticContext() {
        return this.staticContext;
    }

    public XPathExpression createExpression(String expression) throws XPathException {
        Configuration config = this.getConfiguration();
        Executable exec = new Executable(config);
        boolean allowXPath30 = this.staticContext.getXPathVersion() >= 30;
        exec.setTopLevelPackage(this.staticContext.getPackageData());
        exec.setSchemaAware(this.staticContext.getPackageData().isSchemaAware());
        exec.setHostLanguage(54, allowXPath30);
        FunctionLibraryList userlib = exec.getFunctionLibrary();
        FunctionLibraryList lib = new FunctionLibraryList();
        int permittedFunctions = 1;
        if (this.staticContext.getXPathVersion() >= 30) {
            permittedFunctions |= 0x10;
        }
        if (this.staticContext.getXPathVersion() >= 31) {
            permittedFunctions |= 0x80;
        }
        lib.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(permittedFunctions, config));
        lib.addFunctionLibrary(config.getVendorFunctionLibrary());
        lib.addFunctionLibrary(new ConstructorFunctionLibrary(config));
        lib.addFunctionLibrary(config.getIntegratedFunctionLibrary());
        config.addExtensionBinders(lib);
        if (userlib != null) {
            lib.addFunctionLibrary(userlib);
        }
        exec.setFunctionLibrary(lib);
        Expression exp = ExpressionTool.make(expression, this.staticContext, 0, -1, null);
        RetainedStaticContext rsc = this.staticContext.makeRetainedStaticContext();
        exp.setRetainedStaticContext(rsc);
        ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext);
        ItemType contextItemType = this.staticContext.getRequiredContextItemType();
        ContextItemStaticInfo cit = new ContextItemStaticInfo(contextItemType, true);
        exp = exp.typeCheck(visitor, cit).optimize(visitor, cit);
        exp.setRetainedStaticContext(rsc);
        SlotManager map = this.staticContext.getStackFrameMap();
        int numberOfExternalVariables = map.getNumberOfVariables();
        ExpressionTool.allocateSlots(exp, numberOfExternalVariables, map);
        XPathExpression xpe = new XPathExpression(this.staticContext, exp, exec);
        xpe.setStackFrameMap(map, numberOfExternalVariables);
        return xpe;
    }

    public XPathExpression createPattern(String pattern) throws XPathException {
        Executable exec = new Executable(this.getConfiguration());
        Pattern pat = Pattern.make(pattern, this.staticContext, new PackageData(this.getConfiguration()));
        ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext);
        pat.typeCheck(visitor, new ContextItemStaticInfo(Type.NODE_TYPE, true));
        SlotManager map = this.staticContext.getStackFrameMap();
        int slots = map.getNumberOfVariables();
        slots = pat.allocateSlots(map, slots);
        XPathExpression xpe = new XPathExpression(this.staticContext, pat, exec);
        xpe.setStackFrameMap(map, slots);
        return xpe;
    }
}

