/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Stack;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ComponentCode;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeSet
extends ComponentCode<AttributeSet> {
    StructuredQName attributeSetName;
    private boolean declaredStreamable;

    @Override
    public SymbolicName getSymbolicName() {
        return new SymbolicName(136, this.attributeSetName);
    }

    public void setName(StructuredQName attributeSetName) {
        this.attributeSetName = attributeSetName;
    }

    public void setDeclaredStreamable(boolean value) {
        this.declaredStreamable = value;
    }

    public boolean isDeclaredStreamable() {
        return this.declaredStreamable;
    }

    @Override
    public void setStackFrameMap(SlotManager stackFrameMap) {
        if (stackFrameMap != null) {
            super.setStackFrameMap(stackFrameMap);
        }
    }

    public int getFocusDependencies() {
        return this.body.getDependencies() & 0x1E;
    }

    public void expand(XPathContext context) throws XPathException {
        Stack<AttributeSet> stack = context.getController().getAttributeSetEvaluationStack();
        if (stack.contains(this)) {
            throw new XPathException("Attribute set " + this.getObjectName().getEQName() + " invokes itself recursively", "XTDE0640");
        }
        stack.push(this);
        this.getBody().process(context);
        stack.pop();
    }

    @Override
    public int getConstructType() {
        return 136;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.attributeSetName;
    }

    public static void expand(AttributeSet[] asets, XPathContext context) throws XPathException {
        for (AttributeSet aset : asets) {
            aset.expand(context);
        }
    }

    @Override
    public int getComponentKind() {
        return 136;
    }

    @Override
    public void export(ExpressionPresenter presenter) throws XPathException {
        presenter.startElement("attributeSet");
        presenter.emitAttribute("name", this.getObjectName().getEQName());
        presenter.emitAttribute("line", this.getLineNumber() + "");
        presenter.emitAttribute("module", this.getSystemId());
        presenter.emitAttribute("slots", this.getStackFrameMap().getNumberOfVariables() + "");
        presenter.emitAttribute("binds", this.getDeclaringComponent().getComponentBindings().size() + "");
        if (this.isDeclaredStreamable()) {
            presenter.emitAttribute("flags", "s");
        }
        this.getBody().export(presenter);
        presenter.endElement();
    }
}

