/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;

public final class NamePool {
    public static final int FP_MASK = 1048575;
    public static final int USER_DEFINED_MASK = 1047552;
    private static final int MAX_PREFIXES_PER_URI = 1023;
    private static final int MAX_FINGERPRINT = 1048575;
    private final ConcurrentHashMap<StructuredQName, Integer> qNameToInteger = new ConcurrentHashMap(1000);
    private final ConcurrentHashMap<Integer, StructuredQName> integerToQName = new ConcurrentHashMap(1000);
    private AtomicInteger unique = new AtomicInteger(1024);
    private final ConcurrentHashMap<String, List<String>> prefixesForUri = new ConcurrentHashMap(20);

    public NamespaceBinding getNamespaceBinding(int nameCode) {
        String uri = this.getURI(nameCode);
        String prefix = this.getPrefix(nameCode);
        return new NamespaceBinding(prefix, uri);
    }

    public StructuredQName getUnprefixedQName(int nameCode) {
        int fp = nameCode & 0xFFFFF;
        if ((fp & 0xFFC00) == 0) {
            return StandardNames.getUnprefixedStructuredQName(fp);
        }
        return this.integerToQName.get(fp);
    }

    public StructuredQName getStructuredQName(int nameCode) {
        StructuredQName qn = this.getUnprefixedQName(nameCode);
        if (NamePool.isPrefixed(nameCode)) {
            String prefix = this.getPrefix(nameCode);
            return new StructuredQName(prefix, qn.getURI(), qn.getLocalPart());
        }
        return qn;
    }

    public static boolean isPrefixed(int nameCode) {
        return (nameCode & 0x3FF00000) != 0;
    }

    public String suggestPrefixForURI(String uri) {
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        return this.getPrefixWithIndex(uri, 1);
    }

    private String getPrefixWithIndex(String uri, int index) {
        if (index == 0) {
            return "";
        }
        List<String> prefixes = this.prefixesForUri.get(uri);
        if (prefixes == null || prefixes.size() < index) {
            return null;
        }
        return prefixes.get(index - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateIndexForPrefix(String uri, String prefix) {
        int index;
        if (prefix.isEmpty()) {
            return 0;
        }
        List<String> prefixes = this.prefixesForUri.get(uri);
        if (prefixes != null && (index = prefixes.indexOf(prefix)) >= 0) {
            return index + 1;
        }
        if (this.prefixesForUri.size() > 1023) {
            throw new NamePoolLimitException("Too many prefixes (>1023) in use for URI " + uri);
        }
        ConcurrentHashMap<String, List<String>> concurrentHashMap = this.prefixesForUri;
        synchronized (concurrentHashMap) {
            prefixes = this.prefixesForUri.get(uri);
            if (prefixes == null) {
                prefixes = new ArrayList<String>(4);
                this.prefixesForUri.put(uri, prefixes);
            }
            prefixes.add(prefix);
            return prefixes.size();
        }
    }

    public synchronized int allocate(String prefix, String uri, String localName) {
        int fp = this.allocateFingerprint(uri, localName);
        if (prefix.isEmpty()) {
            return fp;
        }
        int prefixIndex = this.allocateIndexForPrefix(uri, prefix);
        return (prefixIndex << 20) + fp;
    }

    private int allocateFingerprint(String uri, String local) {
        int fp;
        if ((NamespaceConstant.isReserved(uri) || "http://saxon.sf.net/".equals(uri)) && (fp = StandardNames.getFingerprint(uri, local)) != -1) {
            return fp;
        }
        StructuredQName qName = new StructuredQName("", uri, local);
        Integer existing = this.qNameToInteger.get(qName);
        if (existing != null) {
            return existing;
        }
        Integer next = this.unique.getAndIncrement();
        if (next > 1048575) {
            throw new NamePoolLimitException("Too many distinct names in NamePool");
        }
        existing = this.qNameToInteger.putIfAbsent(qName, next);
        if (existing == null) {
            this.integerToQName.put(next, qName);
            return next;
        }
        return existing;
    }

    public String getURI(int nameCode) {
        return this.getUnprefixedQName(nameCode).getURI();
    }

    public String getLocalName(int nameCode) {
        return this.getUnprefixedQName(nameCode).getLocalPart();
    }

    public String getPrefix(int nameCode) {
        int prefixIndex = nameCode >> 20 & 0x3FF;
        if (prefixIndex == 0) {
            return "";
        }
        String uri = this.getURI(nameCode);
        return this.getPrefixWithIndex(uri, prefixIndex);
    }

    public String getDisplayName(int nameCode) {
        return this.getStructuredQName(nameCode).getDisplayName();
    }

    public String getClarkName(int nameCode) {
        return this.getUnprefixedQName(nameCode).getClarkName();
    }

    public String getEQName(int nameCode) {
        return this.getUnprefixedQName(nameCode).getEQName();
    }

    public int allocateClarkName(String expandedName) {
        String localName;
        String namespace;
        if (expandedName.charAt(0) == '{') {
            int closeBrace = expandedName.indexOf(125);
            if (closeBrace < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            namespace = expandedName.substring(1, closeBrace);
            if (closeBrace == expandedName.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            localName = expandedName.substring(closeBrace + 1);
        } else {
            namespace = "";
            localName = expandedName;
        }
        return this.allocate("", namespace, localName);
    }

    public int getFingerprint(String uri, String localName) {
        int fp;
        if ((NamespaceConstant.isReserved(uri) || uri.equals("http://saxon.sf.net/")) && (fp = StandardNames.getFingerprint(uri, localName)) != -1) {
            return fp;
        }
        Integer fp2 = this.qNameToInteger.get(new StructuredQName("", uri, localName));
        return fp2 == null ? -1 : fp2;
    }

    public static class NamePoolLimitException
    extends RuntimeException {
        public NamePoolLimitException(String message) {
            super(message);
        }
    }
}

