/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AttributeGetter;
import net.sf.saxon.expr.AxisAtomizingIterator;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AtomizedValueIterator;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.AtomizingIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleAtomicIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.iter.UntypedAtomizingIterator;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public final class Atomizer
extends UnaryExpression {
    private boolean untyped = false;
    private boolean singleValued = false;
    private ItemType operandItemType = null;
    public static final UType STRING_KINDS = UType.NAMESPACE.union(UType.COMMENT).union(UType.PI);
    public static final UType UNTYPED_KINDS = UType.TEXT.union(UType.DOCUMENT);
    public static final UType UNTYPED_IF_UNTYPED_KINDS = UType.TEXT.union(UType.ELEMENT).union(UType.DOCUMENT).union(UType.ATTRIBUTE);

    public Atomizer(Expression sequence) {
        super(sequence);
        sequence.setFlattened(true);
    }

    public static Expression makeAtomizer(Expression sequence) {
        if (sequence instanceof Literal && ((Literal)sequence).getValue() instanceof AtomicSequence) {
            return sequence;
        }
        return new Atomizer(sequence);
    }

    protected OperandRole getOperandRole() {
        return OperandRole.ATOMIC_SEQUENCE;
    }

    public int getImplementationMethod() {
        return 10;
    }

    public ItemType getOperandItemType() {
        if (this.operandItemType == null) {
            this.operandItemType = this.getBaseExpression().getItemType();
        }
        return this.operandItemType;
    }

    public Expression simplify() throws XPathException {
        this.untyped = !this.getPackageData().isSchemaAware();
        this.computeSingleValued(this.getConfiguration().getTypeHierarchy());
        Expression operand = this.getBaseExpression().simplify();
        if (operand instanceof Literal) {
            Item i;
            GroundedValue val = ((Literal)operand).getValue();
            if (val instanceof AtomicValue) {
                return operand;
            }
            UnfailingIterator iter = val.iterate();
            while ((i = iter.next()) != null) {
                if (i instanceof NodeInfo) {
                    return this;
                }
                if (!(i instanceof Function)) continue;
                if (((Function)i).isArray()) {
                    return this;
                }
                XPathException err = new XPathException("Cannot atomize a function item", "FOTY0013");
                err.setLocation(this.getLocation());
                throw err;
            }
            return operand;
        }
        if (operand instanceof ValueOf && (((ValueOf)operand).getOptions() & 1) == 0) {
            return ((ValueOf)operand).convertToCastAsString();
        }
        this.setBaseExpression(operand);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        this.untyped |= !visitor.getStaticContext().getPackageData().isSchemaAware();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.computeSingleValued(th);
        this.resetLocalStaticProperties();
        ItemType operandType = this.getOperandItemType();
        if (th.isSubType(operandType, BuiltInAtomicType.ANY_ATOMIC)) {
            return this.getBaseExpression();
        }
        if (!operandType.isAtomizable()) {
            XPathException err = operandType instanceof FunctionItemType ? new XPathException("Cannot atomize a function item", "FOTY0013") : new XPathException("Cannot atomize an element that is defined in the schema to have element-only content", "FOTY0012");
            err.setIsTypeError(true);
            err.setLocation(this.getLocation());
            throw err;
        }
        this.getBaseExpression().setFlattened(true);
        return this;
    }

    private void computeSingleValued(TypeHierarchy th) {
        ItemType operandType = this.getOperandItemType();
        if (th.relationship(operandType, ArrayItemType.ANY_ARRAY_TYPE) != 4) {
            this.singleValued = false;
        } else {
            ItemType nodeType;
            this.singleValued = this.untyped;
            if (!this.singleValued && (nodeType = this.getBaseExpression().getItemType()) instanceof NodeTest) {
                SchemaType st = ((NodeTest)nodeType).getContentType();
                if (st == Untyped.getInstance() || st.isAtomicType() || st.isComplexType() && st != AnyType.getInstance()) {
                    this.singleValued = true;
                }
                if (!nodeType.getUType().overlaps(UType.ELEMENT.union(UType.ATTRIBUTE))) {
                    this.singleValued = true;
                }
            }
        }
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression exp = super.optimize(visitor, contextInfo);
        if (exp == this) {
            Expression operand;
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType((operand = this.getBaseExpression()).getItemType(), BuiltInAtomicType.ANY_ATOMIC)) {
                return operand;
            }
            if (operand instanceof ValueOf && (((ValueOf)operand).getOptions() & 1) == 0) {
                Expression cast = ((ValueOf)operand).convertToCastAsString();
                return cast.optimize(visitor, contextInfo);
            }
            if (operand instanceof LetExpression || operand instanceof ForExpression) {
                Expression action = ((Assignation)operand).getAction();
                ((Assignation)operand).setAction(new Atomizer(action));
                return operand.optimize(visitor, contextInfo);
            }
            if (operand instanceof Choose) {
                ((Choose)operand).atomizeActions();
                return operand.optimize(visitor, contextInfo);
            }
            if (operand instanceof Block) {
                Operand[] children = ((Block)operand).getOperanda();
                Expression[] atomizedChildren = new Expression[children.length];
                for (int i = 0; i < children.length; ++i) {
                    atomizedChildren[i] = new Atomizer(children[i].getChildExpression());
                }
                Block newBlock = new Block(atomizedChildren);
                return newBlock.typeCheck(visitor, contextInfo).optimize(visitor, contextInfo);
            }
            if (this.untyped && operand instanceof AxisExpression && ((AxisExpression)operand).getAxis() == 2 && ((AxisExpression)operand).getNodeTest() instanceof NameTest) {
                StructuredQName name = ((AxisExpression)operand).getNodeTest().getMatchingNodeName();
                FingerprintedQName qName = new FingerprintedQName(name, visitor.getConfiguration().getNamePool());
                AttributeGetter ag = new AttributeGetter(qName);
                int checks = 0;
                if (((AxisExpression)operand).isContextPossiblyUndefined()) {
                    checks |= 1;
                }
                if (!(((AxisExpression)operand).getContextItemType() instanceof NodeTest)) {
                    checks |= 2;
                }
                ag.setRequiredChecks(checks);
                ExpressionTool.copyLocationInfo(this, ag);
                return ag;
            }
        }
        return exp;
    }

    public boolean isUntyped() {
        return this.untyped;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return (p &= 0xFB40FFFF) | 0x400000;
    }

    public Expression copy(RebindingMap rebindings) {
        Atomizer copy = new Atomizer(this.getBaseExpression().copy(rebindings));
        copy.untyped = this.untyped;
        copy.singleValued = this.singleValued;
        ExpressionTool.copyLocationInfo(this, copy);
        return copy;
    }

    public String getStreamerName() {
        return "Atomizer";
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.getBaseExpression().iterate(context);
        return Atomizer.getAtomizingIterator(base, this.untyped && this.operandItemType instanceof NodeTest);
    }

    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        Item i = this.getBaseExpression().evaluateItem(context);
        if (i == null) {
            return null;
        }
        return i.atomize().head();
    }

    public ItemType getItemType() {
        this.operandItemType = this.getBaseExpression().getItemType();
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return Atomizer.getAtomizedItemType(this.getBaseExpression(), this.untyped, th);
    }

    public static ItemType getAtomizedItemType(Expression operand, boolean alwaysUntyped, TypeHierarchy th) {
        ItemType in = operand.getItemType();
        if (in.isPlainType()) {
            return in;
        }
        if (in instanceof NodeTest) {
            UType kinds = in.getUType();
            if (alwaysUntyped) {
                if (STRING_KINDS.subsumes(kinds)) {
                    return BuiltInAtomicType.STRING;
                }
                if (UNTYPED_IF_UNTYPED_KINDS.subsumes(kinds)) {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
            } else if (UNTYPED_KINDS.subsumes(kinds)) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            return in.getAtomizedItemType();
        }
        if (in instanceof JavaExternalObjectType) {
            return in.getAtomizedItemType();
        }
        if (in instanceof ArrayItemType) {
            PlainType ait = ((ArrayItemType)in).getMemberType().getPrimaryType().getAtomizedItemType();
            return ait == null ? ErrorType.getInstance() : ait;
        }
        if (in instanceof FunctionItemType) {
            return ErrorType.getInstance();
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public int computeCardinality() {
        SchemaType schemaType;
        ItemType in = this.getOperandItemType();
        Expression operand = this.getBaseExpression();
        if (this.singleValued) {
            return operand.getCardinality();
        }
        if (this.untyped && in instanceof NodeTest) {
            return operand.getCardinality();
        }
        if (Cardinality.allowsMany(operand.getCardinality())) {
            return 57344;
        }
        if (in.isPlainType()) {
            return operand.getCardinality();
        }
        if (in instanceof NodeTest && (schemaType = ((NodeTest)in).getContentType()).isAtomicType()) {
            return operand.getCardinality();
        }
        return 57344;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        ItemType operandItemType;
        TypeHierarchy th;
        PathMap.PathMapNodeSet result = this.getBaseExpression().addToPathMap(pathMap, pathMapNodeSet);
        if (result != null && ((th = this.getConfiguration().getTypeHierarchy()).relationship(NodeKindTest.ELEMENT, operandItemType = this.getBaseExpression().getItemType()) != 4 || th.relationship(NodeKindTest.DOCUMENT, operandItemType) != 4)) {
            result.setAtomized();
        }
        return null;
    }

    public static SequenceIterator getAtomizingIterator(SequenceIterator base, boolean oneToOne) throws XPathException {
        int properties = base.getProperties();
        if ((properties & 2) != 0) {
            int count = ((LastPositionFinder)((Object)base)).getLength();
            if (count == 0) {
                return EmptyIterator.emptyIterator();
            }
            if (count == 1) {
                Item first = base.next();
                return first.atomize().iterate();
            }
        } else if ((properties & 8) != 0) {
            return new AxisAtomizingIterator((AtomizedValueIterator)base);
        }
        if (oneToOne) {
            return new UntypedAtomizingIterator(base);
        }
        return new AtomizingIterator(base);
    }

    public String getExpressionName() {
        return "data";
    }

    public String toString() {
        return "data(" + this.getBaseExpression().toString() + ")";
    }

    public String toShortString() {
        return this.getBaseExpression().toShortString();
    }

    public static class AtomizingFunction
    implements MappingFunction {
        private static final AtomizingFunction theInstance = new AtomizingFunction();

        private AtomizingFunction() {
        }

        public static AtomizingFunction getInstance() {
            return theInstance;
        }

        public AtomicIterator map(Item item) throws XPathException {
            if (item instanceof NodeInfo) {
                return ((NodeInfo)item).atomize().iterate();
            }
            if (item instanceof AtomicValue) {
                return new SingleAtomicIterator((AtomicValue)item);
            }
            throw new XPathException("Cannot atomize a function item or external object", "FOTY0013");
        }
    }
}

