/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public class CurrentGroupCall
extends Expression
implements Callable {
    private boolean isInLoop = false;
    private ItemType itemType = AnyItemType.getInstance();
    private ForEachGroup controllingInstruction = null;

    public Expression getScopingExpression() {
        return this.getControllingInstruction();
    }

    public void setControllingInstruction(ForEachGroup instruction, ItemType itemType, boolean isInLoop) {
        this.controllingInstruction = instruction;
        this.isInLoop = isInLoop;
        this.itemType = itemType;
        this.resetLocalStaticProperties();
    }

    public ForEachGroup getControllingInstruction() {
        if (this.controllingInstruction == null) {
            this.controllingInstruction = CurrentGroupCall.findControllingInstruction(this);
        }
        return this.controllingInstruction;
    }

    public static ForEachGroup findControllingInstruction(Expression exp) {
        Expression child = exp;
        for (Expression parent = exp.getParentExpression(); parent != null; parent = parent.getParentExpression()) {
            if (parent instanceof ForEachGroup && (child == ((ForEachGroup)parent).getActionExpression() || child == ((ForEachGroup)parent).getSortKeyDefinitionList())) {
                return (ForEachGroup)parent;
            }
            child = parent;
        }
        return null;
    }

    public boolean isInLoop() {
        return this.isInLoop;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public int getIntrinsicDependencies() {
        return 32;
    }

    protected int computeCardinality() {
        return 57344;
    }

    public int getImplementationMethod() {
        return 2;
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("currentGroup");
        out.endElement();
    }

    public int computeSpecialProperties() {
        if (this.getControllingInstruction() == null) {
            return 0;
        }
        return this.controllingInstruction.getSelectExpression().getSpecialProperties();
    }

    public Expression copy(RebindingMap rebindings) {
        CurrentGroupCall cg = new CurrentGroupCall();
        cg.isInLoop = this.isInLoop;
        cg.itemType = this.itemType;
        cg.controllingInstruction = this.controllingInstruction;
        return cg;
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        GroupIterator gi = c.getCurrentGroupIterator();
        if (gi == null) {
            XPathException err = new XPathException("There is no current group", "XTDE1061");
            err.setLocation(this.getLocation());
            throw err;
        }
        return gi.iterateCurrentGroup();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return SequenceTool.toLazySequence(this.iterate(context));
    }

    public String toString() {
        return "current-group()";
    }

    public String toShortString() {
        return this.toString();
    }

    public String getStreamerName() {
        return "CurrentGroup";
    }
}

