/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.Iterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.NodeWrappingFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeWrappingAxisIterator<B>
implements AxisIterator,
LookaheadIterator {
    private int position = 0;
    private NodeInfo current = null;
    private Iterator<B> base;
    private NodeWrappingFunction<B, NodeInfo> wrappingFunction;

    public NodeWrappingAxisIterator(Iterator<B> base, NodeWrappingFunction<B, NodeInfo> wrappingFunction) {
        this.base = base;
        this.position = 0;
        this.current = null;
        this.wrappingFunction = wrappingFunction;
    }

    public Iterator<B> getBaseIterator() {
        return this.base;
    }

    public NodeWrappingFunction<B, NodeInfo> getNodeWrappingFunction() {
        return this.wrappingFunction;
    }

    @Override
    public boolean hasNext() {
        return this.base.hasNext();
    }

    @Override
    public NodeInfo next() {
        while (this.base.hasNext()) {
            B next = this.base.next();
            if (this.isIgnorable(next)) continue;
            this.current = this.wrappingFunction.wrap(next);
            ++this.position;
            return this.current;
        }
        this.current = null;
        this.position = -1;
        return this.current;
    }

    @Override
    public void close() {
    }

    public boolean isIgnorable(B node) {
        return false;
    }

    @Override
    public int getProperties() {
        return 4;
    }
}

