/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntPredicate;

public final class LocalNameTest
extends NodeTest
implements QNameTest {
    private NamePool namePool;
    private int nodeKind;
    private String localName;
    private UType uType;

    public LocalNameTest(NamePool pool, int nodeKind, String localName) {
        this.namePool = pool;
        this.nodeKind = nodeKind;
        this.localName = localName;
        this.uType = UType.fromTypeCode(nodeKind);
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public UType getUType() {
        return this.uType;
    }

    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        return name != null && nodeKind == this.nodeKind && this.localName.equals(name.getLocalPart());
    }

    public IntPredicate getMatcher(NodeVectorTree tree) {
        final byte[] nodeKindArray = tree.getNodeKindArray();
        final int[] nameCodeArray = tree.getNameCodeArray();
        return new IntPredicate(){

            public boolean matches(int nodeNr) {
                return nodeKindArray[nodeNr] == LocalNameTest.this.nodeKind && LocalNameTest.this.localName.equals(LocalNameTest.this.namePool.getLocalName(nameCodeArray[nodeNr] & 0xFFFFF));
            }
        };
    }

    public boolean matchesNode(NodeInfo node) {
        return this.localName.equals(node.getLocalPart()) && this.nodeKind == node.getNodeKind();
    }

    public boolean matches(StructuredQName qname) {
        return this.localName.equals(qname.getLocalPart());
    }

    public final double getDefaultPriority() {
        return -0.25;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getPrimitiveType() {
        return this.nodeKind;
    }

    public int getNodeKindMask() {
        return 1 << this.nodeKind;
    }

    public String toString() {
        switch (this.nodeKind) {
            case 1: {
                return "*:" + this.localName;
            }
            case 2: {
                return "@*:" + this.localName;
            }
        }
        return "(*" + this.nodeKind + "*):" + this.localName;
    }

    public int hashCode() {
        return this.nodeKind << 20 ^ this.localName.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof LocalNameTest && ((LocalNameTest)other).nodeKind == this.nodeKind && ((LocalNameTest)other).localName.equals(this.localName);
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public String generateJavaScriptNameTest() {
        return "q.local==='" + this.localName + "'";
    }

    public String generateJavaScriptItemTypeTest(ItemType knownToBe) throws XPathException {
        return "var q=SaxonJS.U.nameOfNode(item); return SaxonJS.U.isNode(item) && item.nodeType===" + this.nodeKind + "&&" + this.generateJavaScriptNameTest();
    }
}

