/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntPredicate;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSingletonSet;

public class NameTest
extends NodeTest
implements QNameTest {
    private int nodeKind;
    private int fingerprint;
    private UType uType;
    private NamePool namePool;
    private String uri = null;
    private String localName = null;

    public NameTest(int nodeKind, String uri, String localName, NamePool namePool) {
        this.uri = uri;
        this.localName = localName;
        this.nodeKind = nodeKind;
        this.fingerprint = namePool.allocateFingerprint(uri, localName) & 0xFFFFF;
        this.namePool = namePool;
        this.uType = UType.fromTypeCode(nodeKind);
    }

    public NameTest(int nodeKind, int nameCode, NamePool namePool) {
        this.nodeKind = nodeKind;
        this.fingerprint = nameCode & 0xFFFFF;
        this.namePool = namePool;
        this.uType = UType.fromTypeCode(nodeKind);
    }

    public NameTest(int nodeKind, NodeName name, NamePool pool) {
        this.uri = name.getURI();
        this.localName = name.getLocalPart();
        this.nodeKind = nodeKind;
        this.fingerprint = name.obtainFingerprint(pool);
        this.namePool = pool;
        this.uType = UType.fromTypeCode(nodeKind);
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public UType getUType() {
        return this.uType;
    }

    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        if (nodeKind != this.nodeKind) {
            return false;
        }
        if (name.hasFingerprint()) {
            return name.getFingerprint() == this.fingerprint;
        }
        this.computeUriAndLocal();
        return name.hasURI(this.uri) && name.getLocalPart().equals(this.localName);
    }

    public IntPredicate getMatcher(NodeVectorTree tree) {
        final byte[] nodeKindArray = tree.getNodeKindArray();
        final int[] nameCodeArray = tree.getNameCodeArray();
        return new IntPredicate(){

            public boolean matches(int nodeNr) {
                return (nameCodeArray[nodeNr] & 0xFFFFF) == NameTest.this.fingerprint && nodeKindArray[nodeNr] == NameTest.this.nodeKind;
            }
        };
    }

    public boolean matchesNode(NodeInfo node) {
        if (node.getNodeKind() != this.nodeKind) {
            return false;
        }
        if (node.hasFingerprint()) {
            return node.getFingerprint() == this.fingerprint;
        }
        this.computeUriAndLocal();
        return this.localName.equals(node.getLocalPart()) && this.uri.equals(node.getURI());
    }

    private void computeUriAndLocal() {
        if (this.uri == null) {
            this.uri = this.namePool.getURI(this.fingerprint);
        }
        if (this.localName == null) {
            this.localName = this.namePool.getLocalName(this.fingerprint);
        }
    }

    public boolean matches(StructuredQName qname) {
        this.computeUriAndLocal();
        return qname.getLocalPart().equals(this.localName) && qname.hasURI(this.uri);
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public StructuredQName getMatchingNodeName() {
        this.computeUriAndLocal();
        return new StructuredQName("", this.uri, this.localName);
    }

    public int getPrimitiveType() {
        return this.nodeKind;
    }

    public int getNodeKindMask() {
        return 1 << this.nodeKind;
    }

    public IntSet getRequiredNodeNames() {
        return new IntSingletonSet(this.fingerprint);
    }

    public String getNamespaceURI() {
        this.computeUriAndLocal();
        return this.uri;
    }

    public String getLocalPart() {
        this.computeUriAndLocal();
        return this.localName;
    }

    public String toString() {
        switch (this.nodeKind) {
            case 1: {
                return "element(" + this.namePool.getEQName(this.fingerprint) + ")";
            }
            case 2: {
                return "attribute(" + this.namePool.getEQName(this.fingerprint) + ")";
            }
            case 7: {
                return "processing-instruction(" + this.namePool.getLocalName(this.fingerprint) + ')';
            }
            case 13: {
                return "namespace-node(" + this.namePool.getLocalName(this.fingerprint) + ')';
            }
        }
        return this.namePool.getEQName(this.fingerprint);
    }

    public int hashCode() {
        return this.nodeKind << 20 ^ this.fingerprint;
    }

    public boolean equals(Object other) {
        return other instanceof NameTest && ((NameTest)other).namePool == this.namePool && ((NameTest)other).nodeKind == this.nodeKind && ((NameTest)other).fingerprint == this.fingerprint;
    }

    public String generateJavaScriptNameTest() {
        this.computeUriAndLocal();
        return "q.uri==='" + ExpressionPresenter.jsEscape(this.uri) + "'&&q.local==='" + this.localName + "'";
    }

    public String generateJavaScriptItemTypeTest(ItemType knownToBe) throws XPathException {
        boolean knownKind;
        boolean bl = knownKind = knownToBe.getUType() == this.getUType();
        if (this.nodeKind == 2 && this.getNamespaceURI().equals("")) {
            String nt = "item.name==='" + this.getLocalPart() + "'";
            return "return " + (knownKind ? nt : "SaxonJS.U.isAttr(item) && " + nt);
        }
        String instNode = "";
        if (!knownKind) {
            instNode = knownToBe instanceof NodeTest ? "item.nodeType===" + this.nodeKind + " && " : (this.nodeKind == 2 ? "SaxonJS.U.isAttr(item) && " : (this.nodeKind == 13 ? "SaxonJS.U.isNamespaceNode(item) && " : "SaxonJS.U.isNode(item) && item.nodeType===" + this.nodeKind + " && "));
        }
        return "var q=SaxonJS.U.nameOfNode(item); return " + instNode + this.generateJavaScriptNameTest() + ";";
    }
}

