/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.StringValue;

public class ProcInstImpl
extends NodeImpl {
    String content;
    String name;
    String systemId;
    int lineNumber = -1;

    public ProcInstImpl(String name, String content) {
        this.name = name;
        this.content = content;
    }

    public NodeName getNodeName() {
        return new NoNamespaceName(this.name);
    }

    public String getStringValue() {
        return this.content;
    }

    public AtomicSequence atomize() {
        return new StringValue(this.getStringValue());
    }

    public final int getNodeKind() {
        return 7;
    }

    public void setLocation(String uri, int lineNumber) {
        this.systemId = uri;
        this.lineNumber = lineNumber;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        out.processingInstruction(this.getLocalPart(), this.content, locationId, 0);
    }

    public void rename(NodeName newNameCode) {
        this.name = newNameCode.getLocalPart();
    }

    public void replaceStringValue(CharSequence stringValue) {
        this.content = stringValue.toString();
    }
}

