
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2018 Saxonica Limited.
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at http://mozilla.org/MPL/2.0/.
// This Source Code Form is "Incompatible With Secondary Licenses", as defined by the Mozilla Public License, v. 2.0.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

package net.sf.saxon.lib;

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


/**
 * FeatureCode defines a set of integer constants, representing unique identifiers for the
 * features that can be configured. This module is generated from the master XML
 * file listing all the features.
 *
 * <p>The integer codes are intended to remain stable across Saxon releases so that compiled
 * code using these integer codes will continue to work without recompilation.</p>
 */

public abstract class FeatureCode {

    /** @see Feature#ALLOW_EXTERNAL_FUNCTIONS  */
    public final static int ALLOW_EXTERNAL_FUNCTIONS = 1;
    /** @see Feature#ALLOW_MULTITHREADING  */
    public final static int ALLOW_MULTITHREADING = 2;
    /** @see Feature#ALLOW_OLD_JAVA_URI_FORMAT  */
    public final static int ALLOW_OLD_JAVA_URI_FORMAT = 3;
    /** @see Feature#ALLOW_SYNTAX_EXTENSIONS  */
    public final static int ALLOW_SYNTAX_EXTENSIONS = 4;
    /** @see Feature#ASSERTIONS_CAN_SEE_COMMENTS  */
    public final static int ASSERTIONS_CAN_SEE_COMMENTS = 5;
    /** @see Feature#COLLATION_URI_RESOLVER  */
    public final static int COLLATION_URI_RESOLVER = 6;
    /** @see Feature#COLLATION_URI_RESOLVER_CLASS  */
    public final static int COLLATION_URI_RESOLVER_CLASS = 7;
    /** @see Feature#COLLECTION_FINDER  */
    public final static int COLLECTION_FINDER = 8;
    /** @see Feature#COLLECTION_FINDER_CLASS  */
    public final static int COLLECTION_FINDER_CLASS = 9;
    /** @see Feature#COLLECTION_URI_RESOLVER  */
    public final static int COLLECTION_URI_RESOLVER = 10;
    /** @see Feature#COLLECTION_URI_RESOLVER_CLASS  */
    public final static int COLLECTION_URI_RESOLVER_CLASS = 11;
    /** @see Feature#COMPILE_WITH_TRACING  */
    public final static int COMPILE_WITH_TRACING = 12;
    /** @see Feature#CONFIGURATION  */
    public final static int CONFIGURATION = 13;
    /** @see Feature#CONFIGURATION_FILE  */
    public final static int CONFIGURATION_FILE = 14;
    /** @see Feature#DEBUG_BYTE_CODE  */
    public final static int DEBUG_BYTE_CODE = 15;
    /** @see Feature#DEBUG_BYTE_CODE_DIR  */
    public final static int DEBUG_BYTE_CODE_DIR = 16;
    /** @see Feature#DEFAULT_COLLATION  */
    public final static int DEFAULT_COLLATION = 17;
    /** @see Feature#DEFAULT_COLLECTION  */
    public final static int DEFAULT_COLLECTION = 18;
    /** @see Feature#DEFAULT_COUNTRY  */
    public final static int DEFAULT_COUNTRY = 19;
    /** @see Feature#DEFAULT_LANGUAGE  */
    public final static int DEFAULT_LANGUAGE = 20;
    /** @see Feature#DEFAULT_REGEX_ENGINE  */
    public final static int DEFAULT_REGEX_ENGINE = 21;
    /** @see Feature#DISABLE_XSL_EVALUATE  */
    public final static int DISABLE_XSL_EVALUATE = 22;
    /** @see Feature#DISPLAY_BYTE_CODE  */
    public final static int DISPLAY_BYTE_CODE = 23;
    /** @see Feature#DTD_VALIDATION  */
    public final static int DTD_VALIDATION = 24;
    /** @see Feature#DTD_VALIDATION_RECOVERABLE  */
    public final static int DTD_VALIDATION_RECOVERABLE = 25;
    /** @see Feature#EAGER_EVALUATION  */
    public final static int EAGER_EVALUATION = 26;
    /** @see Feature#ENTITY_RESOLVER_CLASS  */
    public final static int ENTITY_RESOLVER_CLASS = 27;
    /** @see Feature#ENVIRONMENT_VARIABLE_RESOLVER  */
    public final static int ENVIRONMENT_VARIABLE_RESOLVER = 28;
    /** @see Feature#ENVIRONMENT_VARIABLE_RESOLVER_CLASS  */
    public final static int ENVIRONMENT_VARIABLE_RESOLVER_CLASS = 29;
    /** @see Feature#ERROR_LISTENER_CLASS  */
    public final static int ERROR_LISTENER_CLASS = 30;
    /** @see Feature#EXPAND_ATTRIBUTE_DEFAULTS  */
    public final static int EXPAND_ATTRIBUTE_DEFAULTS = 31;
    /** @see Feature#EXPATH_FILE_DELETE_TEMPORARY_FILES  */
    public final static int EXPATH_FILE_DELETE_TEMPORARY_FILES = 32;
    /** @see Feature#GENERATE_BYTE_CODE  */
    public final static int GENERATE_BYTE_CODE = 33;
    /** @see Feature#IGNORE_SAX_SOURCE_PARSER  */
    public final static int IGNORE_SAX_SOURCE_PARSER = 34;
    /** @see Feature#IMPLICIT_SCHEMA_IMPORTS  */
    public final static int IMPLICIT_SCHEMA_IMPORTS = 35;
    /** @see Feature#LAZY_CONSTRUCTION_MODE  */
    public final static int LAZY_CONSTRUCTION_MODE = 36;
    /** @see Feature#LICENSE_FILE_LOCATION  */
    public final static int LICENSE_FILE_LOCATION = 37;
    /** @see Feature#LINE_NUMBERING  */
    public final static int LINE_NUMBERING = 38;
    /** @see Feature#MARK_DEFAULTED_ATTRIBUTES  */
    public final static int MARK_DEFAULTED_ATTRIBUTES = 39;
    /** @see Feature#MAX_COMPILED_CLASSES  */
    public final static int MAX_COMPILED_CLASSES = 40;
    /** @see Feature#MESSAGE_EMITTER_CLASS  */
    public final static int MESSAGE_EMITTER_CLASS = 41;
    /** @see Feature#MODULE_URI_RESOLVER  */
    public final static int MODULE_URI_RESOLVER = 42;
    /** @see Feature#MODULE_URI_RESOLVER_CLASS  */
    public final static int MODULE_URI_RESOLVER_CLASS = 43;
    /** @see Feature#MONITOR_HOT_SPOT_BYTE_CODE  */
    public final static int MONITOR_HOT_SPOT_BYTE_CODE = 44;
    /** @see Feature#MULTIPLE_SCHEMA_IMPORTS  */
    public final static int MULTIPLE_SCHEMA_IMPORTS = 45;
    /** @see Feature#NAME_POOL  */
    public final static int NAME_POOL = 46;
    /** @see Feature#OCCURRENCE_LIMITS  */
    public final static int OCCURRENCE_LIMITS = 47;
    /** @see Feature#OPTIMIZATION_LEVEL  */
    public final static int OPTIMIZATION_LEVEL = 48;
    /** @see Feature#OUTPUT_URI_RESOLVER  */
    public final static int OUTPUT_URI_RESOLVER = 49;
    /** @see Feature#OUTPUT_URI_RESOLVER_CLASS  */
    public final static int OUTPUT_URI_RESOLVER_CLASS = 50;
    /** @see Feature#PRE_EVALUATE_DOC_FUNCTION  */
    public final static int PRE_EVALUATE_DOC_FUNCTION = 51;
    /** @see Feature#PREFER_JAXP_PARSER  */
    public final static int PREFER_JAXP_PARSER = 52;
    /** @see Feature#RECOGNIZE_URI_QUERY_PARAMETERS  */
    public final static int RECOGNIZE_URI_QUERY_PARAMETERS = 53;
    /** @see Feature#RECOVERY_POLICY  */
    public final static int RECOVERY_POLICY = 54;
    /** @see Feature#RECOVERY_POLICY_NAME  */
    public final static int RECOVERY_POLICY_NAME = 55;
    /** @see Feature#RESULT_DOCUMENT_THREADS  */
    public final static int RESULT_DOCUMENT_THREADS = 56;
    /** @see Feature#RETAIN_DTD_ATTRIBUTE_TYPES  */
    public final static int RETAIN_DTD_ATTRIBUTE_TYPES = 57;
    /** @see Feature#SCHEMA_URI_RESOLVER  */
    public final static int SCHEMA_URI_RESOLVER = 58;
    /** @see Feature#SCHEMA_URI_RESOLVER_CLASS  */
    public final static int SCHEMA_URI_RESOLVER_CLASS = 59;
    /** @see Feature#SCHEMA_VALIDATION  */
    public final static int SCHEMA_VALIDATION = 60;
    /** @see Feature#SCHEMA_VALIDATION_MODE  */
    public final static int SCHEMA_VALIDATION_MODE = 61;
    /** @see Feature#SERIALIZER_FACTORY_CLASS  */
    public final static int SERIALIZER_FACTORY_CLASS = 62;
    /** @see Feature#SOURCE_PARSER_CLASS  */
    public final static int SOURCE_PARSER_CLASS = 63;
    /** @see Feature#SOURCE_RESOLVER_CLASS  */
    public final static int SOURCE_RESOLVER_CLASS = 64;
    /** @see Feature#STABLE_COLLECTION_URI  */
    public final static int STABLE_COLLECTION_URI = 65;
    /** @see Feature#STABLE_UNPARSED_TEXT  */
    public final static int STABLE_UNPARSED_TEXT = 66;
    /** @see Feature#STANDARD_ERROR_OUTPUT_FILE  */
    public final static int STANDARD_ERROR_OUTPUT_FILE = 67;
    /** @see Feature#STREAMABILITY  */
    public final static int STREAMABILITY = 68;
    /** @see Feature#STRICT_STREAMABILITY  */
    public final static int STRICT_STREAMABILITY = 69;
    /** @see Feature#STREAMING_FALLBACK  */
    public final static int STREAMING_FALLBACK = 70;
    /** @see Feature#STRIP_WHITESPACE  */
    public final static int STRIP_WHITESPACE = 71;
    /** @see Feature#STYLE_PARSER_CLASS  */
    public final static int STYLE_PARSER_CLASS = 72;
    /** @see Feature#SUPPRESS_EVALUATION_EXPIRY_WARNING  */
    public final static int SUPPRESS_EVALUATION_EXPIRY_WARNING = 73;
    /** @see Feature#SUPPRESS_XPATH_WARNINGS  */
    public final static int SUPPRESS_XPATH_WARNINGS = 74;
    /** @see Feature#SUPPRESS_XSLT_NAMESPACE_CHECK  */
    public final static int SUPPRESS_XSLT_NAMESPACE_CHECK = 75;
    /** @see Feature#THRESHOLD_FOR_COMPILING_TYPES  */
    public final static int THRESHOLD_FOR_COMPILING_TYPES = 76;
    /** @see Feature#TIMING  */
    public final static int TIMING = 77;
    /** @see Feature#TRACE_EXTERNAL_FUNCTIONS  */
    public final static int TRACE_EXTERNAL_FUNCTIONS = 78;
    /** @see Feature#TRACE_LISTENER  */
    public final static int TRACE_LISTENER = 79;
    /** @see Feature#TRACE_LISTENER_CLASS  */
    public final static int TRACE_LISTENER_CLASS = 80;
    /** @see Feature#TRACE_LISTENER_OUTPUT_FILE  */
    public final static int TRACE_LISTENER_OUTPUT_FILE = 81;
    /** @see Feature#TRACE_OPTIMIZER_DECISIONS  */
    public final static int TRACE_OPTIMIZER_DECISIONS = 82;
    /** @see Feature#TREE_MODEL  */
    public final static int TREE_MODEL = 83;
    /** @see Feature#TREE_MODEL_NAME  */
    public final static int TREE_MODEL_NAME = 84;
    /** @see Feature#UNPARSED_TEXT_URI_RESOLVER  */
    public final static int UNPARSED_TEXT_URI_RESOLVER = 85;
    /** @see Feature#UNPARSED_TEXT_URI_RESOLVER_CLASS  */
    public final static int UNPARSED_TEXT_URI_RESOLVER_CLASS = 86;
    /** @see Feature#URI_RESOLVER_CLASS  */
    public final static int URI_RESOLVER_CLASS = 87;
    /** @see Feature#USE_PI_DISABLE_OUTPUT_ESCAPING  */
    public final static int USE_PI_DISABLE_OUTPUT_ESCAPING = 88;
    /** @see Feature#USE_TYPED_VALUE_CACHE  */
    public final static int USE_TYPED_VALUE_CACHE = 89;
    /** @see Feature#USE_XSI_SCHEMA_LOCATION  */
    public final static int USE_XSI_SCHEMA_LOCATION = 90;
    /** @see Feature#VALIDATION_COMMENTS  */
    public final static int VALIDATION_COMMENTS = 91;
    /** @see Feature#VALIDATION_WARNINGS  */
    public final static int VALIDATION_WARNINGS = 92;
    /** @see Feature#VERSION_WARNING  */
    public final static int VERSION_WARNING = 93;
    /** @see Feature#XINCLUDE  */
    public final static int XINCLUDE = 94;
    /** @see Feature#XML_VERSION  */
    public final static int XML_VERSION = 95;
    /** @see Feature#XML_PARSER_FEATURE  */
    public final static int XML_PARSER_FEATURE = 96;
    /** @see Feature#XML_PARSER_PROPERTY  */
    public final static int XML_PARSER_PROPERTY = 97;
    /** @see Feature#XQUERY_ALLOW_UPDATE  */
    public final static int XQUERY_ALLOW_UPDATE = 98;
    /** @see Feature#XQUERY_CONSTRUCTION_MODE  */
    public final static int XQUERY_CONSTRUCTION_MODE = 99;
    /** @see Feature#XQUERY_DEFAULT_ELEMENT_NAMESPACE  */
    public final static int XQUERY_DEFAULT_ELEMENT_NAMESPACE = 100;
    /** @see Feature#XQUERY_DEFAULT_FUNCTION_NAMESPACE  */
    public final static int XQUERY_DEFAULT_FUNCTION_NAMESPACE = 101;
    /** @see Feature#XQUERY_EMPTY_LEAST  */
    public final static int XQUERY_EMPTY_LEAST = 102;
    /** @see Feature#XQUERY_INHERIT_NAMESPACES  */
    public final static int XQUERY_INHERIT_NAMESPACES = 103;
    /** @see Feature#XQUERY_MULTIPLE_MODULE_IMPORTS  */
    public final static int XQUERY_MULTIPLE_MODULE_IMPORTS = 104;
    /** @see Feature#XQUERY_PRESERVE_BOUNDARY_SPACE  */
    public final static int XQUERY_PRESERVE_BOUNDARY_SPACE = 105;
    /** @see Feature#XQUERY_PRESERVE_NAMESPACES  */
    public final static int XQUERY_PRESERVE_NAMESPACES = 106;
    /** @see Feature#XQUERY_REQUIRED_CONTEXT_ITEM_TYPE  */
    public final static int XQUERY_REQUIRED_CONTEXT_ITEM_TYPE = 107;
    /** @see Feature#XQUERY_SCHEMA_AWARE  */
    public final static int XQUERY_SCHEMA_AWARE = 108;
    /** @see Feature#XQUERY_STATIC_ERROR_LISTENER_CLASS  */
    public final static int XQUERY_STATIC_ERROR_LISTENER_CLASS = 109;
    /** @see Feature#XQUERY_VERSION  */
    public final static int XQUERY_VERSION = 110;
    /** @see Feature#XSD_VERSION  */
    public final static int XSD_VERSION = 111;
    /** @see Feature#XSLT_ENABLE_ASSERTIONS  */
    public final static int XSLT_ENABLE_ASSERTIONS = 112;
    /** @see Feature#XSLT_INITIAL_MODE  */
    public final static int XSLT_INITIAL_MODE = 113;
    /** @see Feature#XSLT_INITIAL_TEMPLATE  */
    public final static int XSLT_INITIAL_TEMPLATE = 114;
    /** @see Feature#XSLT_SCHEMA_AWARE  */
    public final static int XSLT_SCHEMA_AWARE = 115;
    /** @see Feature#XSLT_STATIC_ERROR_LISTENER_CLASS  */
    public final static int XSLT_STATIC_ERROR_LISTENER_CLASS = 116;
    /** @see Feature#XSLT_STATIC_URI_RESOLVER_CLASS  */
    public final static int XSLT_STATIC_URI_RESOLVER_CLASS = 117;
    /** @see Feature#XSLT_VERSION  */
    public final static int XSLT_VERSION = 118;
    /** @see Feature#REGEX_BACKTRACKING_LIMIT  */
    public final static int REGEX_BACKTRACKING_LIMIT = 119;
    /** @see Feature#XPATH_VERSION_FOR_XSD  */
    public final static int XPATH_VERSION_FOR_XSD = 120;
    /** @see Feature#XPATH_VERSION_FOR_XSLT  */
    public final static int XPATH_VERSION_FOR_XSLT = 121;


    public final static int MAX = 122;

}

