/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.Arrays;
import net.sf.saxon.ma.arrays.AbstractArrayItem;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.parray.PSequence;
import net.sf.saxon.ma.parray.TreePVector;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

public class PersistentArrayItem
extends AbstractArrayItem {
    private TreePVector<GroundedValue<? extends Item>> vector;

    public PersistentArrayItem(ArrayItem other) {
        this.vector = TreePVector.empty();
        for (GroundedValue<? extends Item> member : other.members()) {
            this.vector = this.vector.plus((Object)member);
        }
    }

    private PersistentArrayItem(TreePVector<GroundedValue<? extends Item>> vector) {
        this.vector = vector;
    }

    @Override
    public GroundedValue<? extends Item> get(int index) throws XPathException {
        try {
            return this.vector.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new XPathException(e.getMessage(), "FOAY0001");
        }
    }

    public ArrayItem put(int index, GroundedValue newValue) throws XPathException {
        try {
            PSequence v2 = this.vector.with(index, (Object)newValue);
            return v2 == this.vector ? this : new PersistentArrayItem((TreePVector<GroundedValue<? extends Item>>)v2);
        }
        catch (IndexOutOfBoundsException e) {
            throw new XPathException(e.getMessage(), "FOAY0001");
        }
    }

    @Override
    public ArrayItem insert(int position, GroundedValue<? extends Item> member) {
        PSequence v2 = this.vector.plus(position, (Object)member);
        return new PersistentArrayItem((TreePVector<GroundedValue<? extends Item>>)v2);
    }

    @Override
    public int arrayLength() {
        return this.vector.size();
    }

    @Override
    public boolean isEmpty() {
        return this.vector.isEmpty();
    }

    @Override
    public Iterable<GroundedValue<? extends Item>> members() {
        return this.vector;
    }

    @Override
    public ArrayItem subArray(int start, int end) {
        return new PersistentArrayItem((TreePVector<GroundedValue<? extends Item>>)this.vector.subList(start, end));
    }

    @Override
    public ArrayItem concat(ArrayItem other) {
        if (other.arrayLength() == 0) {
            return this;
        }
        TreePVector<GroundedValue<? extends Item>> v1 = other instanceof PersistentArrayItem ? ((PersistentArrayItem)other).vector : new PersistentArrayItem((ArrayItem)other).vector;
        PSequence v2 = this.vector.plusAll(v1);
        return new PersistentArrayItem((TreePVector<GroundedValue<? extends Item>>)v2);
    }

    @Override
    public ArrayItem remove(int index) {
        PSequence v2 = this.vector.minus(index);
        return v2 == this.vector ? this : new PersistentArrayItem((TreePVector<GroundedValue<? extends Item>>)v2);
    }

    @Override
    public ArrayItem removeSeveral(IntSet positions) {
        int[] p = new int[positions.size()];
        int i = 0;
        IntIterator ii = positions.iterator();
        while (ii.hasNext()) {
            p[i++] = ii.next();
        }
        Arrays.sort(p);
        PSequence<GroundedValue<Item<Object>>> v2 = this.vector;
        for (int j = p.length - 1; j >= 0; --j) {
            v2 = v2.minus(p[j]);
        }
        return v2 == this.vector ? this : new PersistentArrayItem((TreePVector<GroundedValue<? extends Item>>)v2);
    }
}

