/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.function.Consumer;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ItemConsumer;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.EmptySequence;

public class SingletonIterator<T extends Item>
implements SequenceIterator<T>,
UnfailingIterator<T>,
ReversibleIterator<T>,
LastPositionFinder,
GroundedIterator<T>,
LookaheadIterator<T> {
    private T item;
    boolean gone = false;

    private SingletonIterator(T value) {
        this.item = value;
    }

    public static <T extends Item> UnfailingIterator<T> makeIterator(T item) {
        if (item == null) {
            return EmptyIterator.emptyIterator();
        }
        return new SingletonIterator<T>(item);
    }

    public static <T extends Item> SingletonIterator<T> rawIterator(T item) {
        assert (item != null);
        return new SingletonIterator<T>(item);
    }

    @Override
    public boolean hasNext() {
        return !this.gone;
    }

    @Override
    public T next() {
        if (this.gone) {
            return null;
        }
        this.gone = true;
        return this.item;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void close() {
    }

    @Override
    public SingletonIterator<T> getReverseIterator() {
        return new SingletonIterator<T>(this.item);
    }

    public Item getValue() {
        return this.item;
    }

    @Override
    public GroundedValue<T> materialize() {
        if (this.item instanceof GroundedValue) {
            return this.item;
        }
        return new ZeroOrOne<T>(this.item);
    }

    @Override
    public GroundedValue getResidue() {
        return this.gone ? EmptySequence.getInstance() : this.materialize();
    }

    @Override
    public int getProperties() {
        return 7;
    }

    @Override
    public void forEach(Consumer<T> consumer) {
        consumer.accept(this.item);
    }

    @Override
    public void forEachOrFail(ItemConsumer<T> consumer) throws XPathException {
        if (!this.gone) {
            consumer.accept(this.item);
        }
    }
}

