/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj.pull;

import com.saxonica.xqj.pull.TreeWalker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pull.UnfailingPullProvider;
import net.sf.saxon.pull.UnparsedEntity;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.GraftedElement;
import net.sf.saxon.tree.tiny.TinyAttributeCollection;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;

public class TinyTreeWalker
implements UnfailingPullProvider,
Location {
    private int startNode;
    private int currentNode;
    private int currentEvent;
    private TinyTree tree;
    private int[] treeNameCodes;
    private short[] treeDepth;
    private SchemaType[] treeTypes;
    private int[] treeNext;
    private int[] treeAlpha;
    private PipelineConfiguration pipe;
    private NamespaceBinding[] nsBuffer = new NamespaceBinding[10];
    private UnfailingPullProvider graftedTreeWalker = null;

    public TinyTreeWalker(TinyNodeImpl startNode) {
        int kind = startNode.getNodeKind();
        if (kind == 2 || kind == 13) {
            throw new IllegalArgumentException("TinyTreeWalker cannot start at an attribute or namespace node");
        }
        this.startNode = startNode.getNodeNumber();
        this.tree = startNode.getTree();
        this.treeNameCodes = this.tree.getNameCodeArray();
        this.treeNext = this.tree.getNextPointerArray();
        this.treeDepth = this.tree.getNodeDepthArray();
        this.treeTypes = this.tree.getTypeArray();
        this.treeAlpha = this.tree.getAlphaArray();
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public int next() throws XPathException {
        if (this.graftedTreeWalker != null) {
            int n = this.graftedTreeWalker.next();
            if (n == -1) {
                this.graftedTreeWalker = null;
            } else {
                return n;
            }
        }
        switch (this.currentEvent) {
            case 0: {
                this.currentNode = this.startNode;
                switch (this.tree.nodeKind[this.currentNode]) {
                    case 9: {
                        this.currentEvent = 2;
                        return 2;
                    }
                    case 1: 
                    case 17: {
                        this.currentEvent = 4;
                        return 4;
                    }
                    case 3: 
                    case 4: {
                        this.currentEvent = 8;
                        return 8;
                    }
                    case 8: {
                        this.currentEvent = 9;
                        return 9;
                    }
                    case 7: {
                        this.currentEvent = 10;
                        break;
                    }
                    case 12: {
                        throw new IllegalStateException("Current node is a parent-pointer pseudo-node");
                    }
                    case 33: {
                        GraftedElement graft = (GraftedElement)this.tree.getNode(this.currentNode - 1);
                        NodeInfo externalNode = graft.getExternalNode();
                        this.graftedTreeWalker = TreeWalker.makeTreeWalker(externalNode);
                        this.graftedTreeWalker.setPipelineConfiguration(this.getPipelineConfiguration());
                        return this.next();
                    }
                }
                return this.currentEvent;
            }
            case 2: 
            case 4: {
                if (this.tree.nodeKind[this.currentNode] == 17) {
                    this.currentEvent = 8;
                    return 8;
                }
                if (this.tree.nodeKind[this.currentNode] == 33) {
                    this.currentNode = this.treeNext[this.currentNode];
                    this.currentEvent = 5;
                    return 5;
                }
                if (this.treeDepth[this.currentNode + 1] > this.treeDepth[this.currentNode]) {
                    switch (this.tree.nodeKind[++this.currentNode]) {
                        case 1: 
                        case 17: {
                            this.currentEvent = 4;
                            return 4;
                        }
                        case 3: 
                        case 4: {
                            this.currentEvent = 8;
                            return 8;
                        }
                        case 8: {
                            this.currentEvent = 9;
                            return 9;
                        }
                        case 7: {
                            this.currentEvent = 10;
                            return 10;
                        }
                        case 12: {
                            throw new IllegalStateException("First child node must not be a parent-pointer pseudo-node");
                        }
                        case 33: {
                            GraftedElement graft = (GraftedElement)this.tree.getNode(this.currentNode);
                            NodeInfo externalNode = graft.getExternalNode();
                            this.graftedTreeWalker = TreeWalker.makeTreeWalker(externalNode);
                            this.graftedTreeWalker.setPipelineConfiguration(this.getPipelineConfiguration());
                            return this.graftedTreeWalker.next();
                        }
                    }
                    return this.currentEvent;
                }
                if (this.currentEvent == 2) {
                    this.currentEvent = 3;
                    return 3;
                }
                this.currentEvent = 5;
                return 5;
            }
            case 8: {
                if (this.tree.nodeKind[this.currentNode] == 17) {
                    this.currentEvent = 5;
                    return 5;
                }
            }
            case 5: 
            case 9: 
            case 10: {
                if (this.currentNode == this.startNode) {
                    this.currentEvent = -1;
                    return -1;
                }
                int next = this.treeNext[this.currentNode];
                if (next > this.currentNode) {
                    this.currentNode = this.treeNext[this.currentNode];
                    do {
                        switch (this.tree.nodeKind[this.currentNode]) {
                            case 1: {
                                this.currentEvent = 4;
                                return 4;
                            }
                            case 3: 
                            case 4: {
                                this.currentEvent = 8;
                                return 8;
                            }
                            case 8: {
                                this.currentEvent = 9;
                                return 9;
                            }
                            case 7: {
                                this.currentEvent = 10;
                                return 10;
                            }
                            case 12: {
                                this.currentEvent = -1;
                                ++this.currentNode;
                            }
                        }
                    } while (this.currentEvent == -1);
                    return this.currentEvent;
                }
                if (next == -1) {
                    this.currentNode = next;
                    this.currentEvent = -1;
                    return -1;
                }
                switch (this.tree.nodeKind[next]) {
                    case 1: 
                    case 17: {
                        this.currentEvent = 5;
                        break;
                    }
                    case 9: {
                        this.currentEvent = 3;
                    }
                }
                this.currentNode = next;
                return this.currentEvent;
            }
            case 3: 
            case 6: 
            case 7: {
                this.currentEvent = -1;
                return -1;
            }
            case -1: {
                throw new IllegalStateException("Cannot call next() when input is exhausted");
            }
        }
        throw new IllegalStateException("Unrecognized event " + this.currentEvent);
    }

    public int current() {
        if (this.graftedTreeWalker != null) {
            return this.graftedTreeWalker.current();
        }
        return this.currentEvent;
    }

    public AttributeCollection getAttributes() {
        if (this.graftedTreeWalker != null) {
            return this.graftedTreeWalker.getAttributes();
        }
        if ((this.tree.nodeKind[this.currentNode] & 0xF) == 1) {
            if (this.treeAlpha[this.currentNode] == -1) {
                return AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION;
            }
            return new TinyAttributeCollection(this.tree, this.currentNode);
        }
        throw new IllegalStateException("getAttributes() called when current event is not ELEMENT_START");
    }

    public NamespaceBinding[] getNamespaceDeclarations() {
        if (this.graftedTreeWalker != null) {
            return this.graftedTreeWalker.getNamespaceDeclarations();
        }
        if ((this.tree.nodeKind[this.currentNode] & 0xF) == 1) {
            if (this.currentNode == this.startNode) {
                ArrayList list = new ArrayList();
                Iterator iter = NamespaceIterator.iterateNamespaces((NodeInfo)this.tree.getNode(this.currentNode));
                iter.forEachRemaining(list::add);
                return list.toArray(NamespaceBinding.EMPTY_ARRAY);
            }
            return TinyElementImpl.getDeclaredNamespaces((TinyTree)this.tree, (int)this.currentNode, (NamespaceBinding[])this.nsBuffer);
        }
        throw new IllegalStateException("getNamespaceDeclarations() called when current event is not START_ELEMENT");
    }

    public int skipToMatchingEnd() {
        if (this.graftedTreeWalker != null) {
            return this.graftedTreeWalker.skipToMatchingEnd();
        }
        switch (this.currentEvent) {
            case 2: {
                this.currentEvent = 3;
                return 3;
            }
            case 4: {
                this.currentEvent = 5;
                return 5;
            }
        }
        throw new IllegalStateException("Cannot call skipToMatchingEnd() except when at start of element or document");
    }

    public void close() {
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public NodeName getNodeName() {
        if (this.graftedTreeWalker != null) {
            return this.graftedTreeWalker.getNodeName();
        }
        switch (this.currentEvent) {
            case 4: 
            case 5: 
            case 10: {
                return new CodedName(this.treeNameCodes[this.currentNode], "", this.getNamePool());
            }
        }
        throw new IllegalStateException("getNodeName() called when its value is undefined");
    }

    public CharSequence getStringValue() throws XPathException {
        if (this.graftedTreeWalker != null) {
            return this.graftedTreeWalker.getStringValue();
        }
        switch (this.tree.nodeKind[this.currentNode]) {
            case 3: {
                return TinyTextImpl.getStringValue((TinyTree)this.tree, (int)this.currentNode);
            }
            case 4: {
                return WhitespaceTextImpl.getStringValueCS((TinyTree)this.tree, (int)this.currentNode);
            }
            case 7: 
            case 8: {
                return this.tree.getNode(this.currentNode).getStringValue();
            }
            case 1: 
            case 17: {
                return TinyParentNodeImpl.getStringValueCS((TinyTree)this.tree, (int)this.currentNode);
            }
            case 12: {
                throw new IllegalStateException("Trying to get string value of a parent-pointer pseudo node");
            }
        }
        return null;
    }

    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public SchemaType getSchemaType() {
        if (this.graftedTreeWalker != null) {
            return this.graftedTreeWalker.getSchemaType();
        }
        if (this.tree.nodeKind[this.currentNode] != 1) {
            throw new IllegalStateException("getTypeAnnotation() called when current event is not ELEMENT_START or ");
        }
        if (this.treeTypes == null) {
            return Untyped.getInstance();
        }
        return this.treeTypes[this.currentNode];
    }

    public Location getSourceLocator() {
        return this;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.tree.getSystemId(this.currentNode);
    }

    public int getLineNumber() {
        return this.tree.getLineNumber(this.currentNode);
    }

    public int getColumnNumber() {
        return -1;
    }

    public Location saveLocation() {
        return new ExplicitLocation(this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
    }

    public List<UnparsedEntity> getUnparsedEntities() {
        return null;
    }
}

