/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.xpath.XPathEvaluator;

public class XPathFactoryImpl
extends XPathFactory {
    private Configuration config = new Configuration();
    private XPathVariableResolver variableResolver;
    private XPathFunctionResolver functionResolver;

    public boolean isObjectModelSupported(String string) {
        if (string.equals("http://saxon.sf.net/jaxp/xpath/om")) {
            return true;
        }
        if (string.equals("http://java.sun.com/jaxp/xpath/dom")) {
            return true;
        }
        if (string.equals("http://jdom.org/jaxp/xpath/jdom")) {
            return true;
        }
        return string.equals("http://www.xom.nu/jaxp/xpath/xom");
    }

    public void setFeature(String string, boolean bl) throws XPathFactoryConfigurationException {
        if (!string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            throw new XPathFactoryConfigurationException("Unknown feature: " + string);
        }
        this.config.setAllowExternalFunctions(!bl);
    }

    public boolean getFeature(String string) throws XPathFactoryConfigurationException {
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return !this.config.isAllowExternalFunctions();
        }
        throw new XPathFactoryConfigurationException("Unknown feature: " + string);
    }

    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.variableResolver = xPathVariableResolver;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        this.functionResolver = xPathFunctionResolver;
    }

    public XPath newXPath() {
        XPathEvaluator xPathEvaluator = new XPathEvaluator(this.config);
        xPathEvaluator.setXPathFunctionResolver(this.functionResolver);
        xPathEvaluator.setXPathVariableResolver(this.variableResolver);
        return xPathEvaluator;
    }
}

