/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.data;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.scuba.data.ISOCountry;
import net.sf.scuba.data.TestCountry;
import net.sf.scuba.data.UnicodeCountry;

public abstract class Country {
    private static final Class<?>[] SUB_CLASSES = new Class[]{UnicodeCountry.class, ISOCountry.class, TestCountry.class};

    public static Country getInstance(int code) {
        for (Country country : Country.values()) {
            if (country.valueOf() != code) continue;
            return country;
        }
        throw new IllegalArgumentException("Illegal country code" + Integer.toHexString(code));
    }

    public static Country getInstance(String code) {
        if (code == null) {
            throw new IllegalArgumentException("Illegal country code");
        }
        code = code.trim();
        switch (code.length()) {
            case 2: {
                return Country.fromAlpha2(code);
            }
            case 3: {
                return Country.fromAlpha3(code);
            }
        }
        throw new IllegalArgumentException("Illegal country code " + code);
    }

    public static Country[] values() {
        ArrayList<Country> result = new ArrayList<Country>();
        for (Class<?> subClass : SUB_CLASSES) {
            if (!Country.class.isAssignableFrom(subClass)) continue;
            try {
                Method method = subClass.getMethod("values", new Class[0]);
                Country[] subClassValues = (Country[])method.invoke(null, new Object[0]);
                result.addAll(Arrays.asList(subClassValues));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Country[] values = new Country[result.size()];
        result.toArray(values);
        return values;
    }

    public abstract int valueOf();

    public abstract String getName();

    public abstract String getNationality();

    public abstract String toAlpha2Code();

    public abstract String toAlpha3Code();

    private static Country fromAlpha2(String code) {
        for (Country country : Country.values()) {
            if (!country.toAlpha2Code().equals(code)) continue;
            return country;
        }
        throw new IllegalArgumentException("Unknown country code " + code);
    }

    private static Country fromAlpha3(String code) {
        for (Country country : Country.values()) {
            if (!country.toAlpha3Code().equals(code)) continue;
            return country;
        }
        throw new IllegalArgumentException("Unknown country code " + code);
    }
}

