/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sf.scuba.smartcards.APDUEvent;
import net.sf.scuba.smartcards.APDUListener;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;

public abstract class CardService
implements Serializable {
    private static final long serialVersionUID = 5618527358158494957L;
    protected static final int SESSION_STOPPED_STATE = 0;
    protected static final int SESSION_STARTED_STATE = 1;
    private static final Map<String, String> objectToServiceMap = new HashMap<String, String>();
    private Collection<APDUListener> apduListeners = new HashSet<APDUListener>();
    protected int state = 0;

    public static CardService getInstance(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Class<?> objectClass = object.getClass();
        String objectClassName = objectClass.getCanonicalName();
        for (Map.Entry<String, String> entry : objectToServiceMap.entrySet()) {
            String targetObjectClassName = entry.getKey();
            try {
                Class<?> targetObjectClass = Class.forName(targetObjectClassName);
                String serviceClassName = entry.getValue();
                if (!targetObjectClass.isInstance(object)) continue;
                try {
                    Class<?> cardServiceClass = Class.forName(serviceClassName);
                    return (CardService)cardServiceClass.getConstructor(targetObjectClass).newInstance(object);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new IllegalArgumentException("Could not find a CardService for object of class \"" + objectClassName + "\"");
    }

    public void addAPDUListener(APDUListener l) {
        if (this.apduListeners != null) {
            this.apduListeners.add(l);
        }
    }

    public void removeAPDUListener(APDUListener l) {
        if (this.apduListeners != null) {
            this.apduListeners.remove(l);
        }
    }

    protected void notifyExchangedAPDU(int count, CommandAPDU capdu, ResponseAPDU rapdu) {
        if (this.apduListeners == null || this.apduListeners.size() < 1) {
            return;
        }
        APDUEvent event = new APDUEvent(this, "RAW", count, capdu, rapdu);
        for (APDUListener listener : this.apduListeners) {
            listener.exchangedAPDU(event);
        }
    }

    public abstract void open() throws CardServiceException;

    public abstract boolean isOpen();

    public abstract ResponseAPDU transmit(CommandAPDU var1) throws CardServiceException;

    public abstract byte[] getATR() throws CardServiceException;

    public boolean isExtendedAPDULengthSupported() {
        return false;
    }

    public abstract void close();

    static {
        objectToServiceMap.put("javax.smartcardio.CardTerminal", "net.sf.scuba.smartcards.TerminalCardService");
        objectToServiceMap.put("sun.security.smartcardio.TerminalImpl", "net.sf.scuba.smartcards.TerminalCardService");
        objectToServiceMap.put("android.nfc.tech.IsoDep", "net.sf.scuba.smartcards.IsoDepCardService");
    }
}

