/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TLVInputState
implements Cloneable {
    private Stack<TLStruct> state;
    private boolean isAtStartOfTag;
    private boolean isAtStartOfLength;
    private boolean isReadingValue;

    public TLVInputState() {
        this.state = new Stack();
        this.isAtStartOfTag = true;
        this.isAtStartOfLength = false;
        this.isReadingValue = false;
    }

    private TLVInputState(Stack<TLStruct> state, boolean isAtStartOfTag, boolean isAtStartOfLength, boolean isReadingValue) {
        this.state = state;
        this.isAtStartOfTag = isAtStartOfTag;
        this.isAtStartOfLength = isAtStartOfLength;
        this.isReadingValue = isReadingValue;
    }

    public boolean isAtStartOfTag() {
        return this.isAtStartOfTag;
    }

    public boolean isAtStartOfLength() {
        return this.isAtStartOfLength;
    }

    public boolean isProcessingValue() {
        return this.isReadingValue;
    }

    public int getTag() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Tag not yet read.");
        }
        TLStruct currentObject = this.state.peek();
        return currentObject.getTag();
    }

    public int getLength() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Length not yet known.");
        }
        TLStruct currentObject = this.state.peek();
        int length = currentObject.getLength();
        return length;
    }

    public int getValueBytesProcessed() {
        TLStruct currentObject = this.state.peek();
        return currentObject.getValueBytesProcessed();
    }

    public int getValueBytesLeft() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Length of value is unknown.");
        }
        TLStruct currentObject = this.state.peek();
        int currentLength = currentObject.getLength();
        int valueBytesRead = currentObject.getValueBytesProcessed();
        return currentLength - valueBytesRead;
    }

    public void setTagProcessed(int tag, int byteCount) {
        TLStruct obj = new TLStruct(tag);
        if (!this.state.isEmpty()) {
            TLStruct parent = this.state.peek();
            parent.updateValueBytesProcessed(byteCount);
        }
        this.state.push(obj);
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = true;
        this.isReadingValue = false;
    }

    public void setDummyLengthProcessed() {
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = false;
        this.isReadingValue = true;
    }

    public void setLengthProcessed(int length, int byteCount) {
        if (length < 0) {
            throw new IllegalArgumentException("Cannot set negative length (length = " + length + ", 0x" + Integer.toHexString(length) + " for tag " + Integer.toHexString(this.getTag()) + ").");
        }
        TLStruct obj = this.state.pop();
        if (!this.state.isEmpty()) {
            TLStruct parent = this.state.peek();
            parent.updateValueBytesProcessed(byteCount);
        }
        obj.setLength(length);
        this.state.push(obj);
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = false;
        this.isReadingValue = true;
    }

    public void updateValueBytesProcessed(int byteCount) {
        if (this.state.isEmpty()) {
            return;
        }
        TLStruct currentObject = this.state.peek();
        int bytesLeft = currentObject.getLength() - currentObject.getValueBytesProcessed();
        if (byteCount > bytesLeft) {
            throw new IllegalArgumentException("Cannot process " + byteCount + " bytes! Only " + bytesLeft + " bytes left in this TLV object " + currentObject);
        }
        currentObject.updateValueBytesProcessed(byteCount);
        int currentLength = currentObject.getLength();
        if (currentObject.getValueBytesProcessed() == currentLength) {
            this.state.pop();
            this.updateValueBytesProcessed(currentLength);
            this.isAtStartOfTag = true;
            this.isAtStartOfLength = false;
            this.isReadingValue = false;
        } else {
            this.isAtStartOfTag = false;
            this.isAtStartOfLength = false;
            this.isReadingValue = true;
        }
    }

    public Object clone() {
        Stack<TLStruct> newState = new Stack<TLStruct>();
        for (int i = 0; i < this.state.size(); ++i) {
            TLStruct tlStruct = (TLStruct)this.state.get(i);
            newState.add((TLStruct)tlStruct.clone());
        }
        return new TLVInputState(newState, this.isAtStartOfTag, this.isAtStartOfLength, this.isReadingValue);
    }

    public String toString() {
        return this.state.toString();
    }

    private class TLStruct
    implements Cloneable {
        private int tag;
        private int length;
        private int valueBytesRead;

        public TLStruct(int tag) {
            this.tag = tag;
            this.length = Integer.MAX_VALUE;
            this.valueBytesRead = 0;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getTag() {
            return this.tag;
        }

        public int getLength() {
            return this.length;
        }

        public int getValueBytesProcessed() {
            return this.valueBytesRead;
        }

        public void updateValueBytesProcessed(int n) {
            this.valueBytesRead += n;
        }

        public Object clone() {
            TLStruct copy = new TLStruct(this.tag);
            copy.length = this.length;
            copy.valueBytesRead = this.valueBytesRead;
            return copy;
        }

        public String toString() {
            return "[TLStruct " + Integer.toHexString(this.tag) + ", " + this.length + ", " + this.valueBytesRead + "]";
        }
    }
}

