/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Stack;
import net.sf.scuba.tlv.TLVUtil;
import net.sf.scuba.util.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TLVOutputState
implements Cloneable {
    private Stack<TLVStruct> state;
    private boolean isAtStartOfTag;
    private boolean isAtStartOfLength;
    private boolean isReadingValue;

    public TLVOutputState() {
        this.state = new Stack();
        this.isAtStartOfTag = true;
        this.isAtStartOfLength = false;
        this.isReadingValue = false;
    }

    private TLVOutputState(Stack<TLVStruct> state, boolean isAtStartOfTag, boolean isAtStartOfLength, boolean isReadingValue) {
        this.state = state;
        this.isAtStartOfTag = isAtStartOfTag;
        this.isAtStartOfLength = isAtStartOfLength;
        this.isReadingValue = isReadingValue;
    }

    public boolean isAtStartOfTag() {
        return this.isAtStartOfTag;
    }

    public boolean isAtStartOfLength() {
        return this.isAtStartOfLength;
    }

    public boolean isProcessingValue() {
        return this.isReadingValue;
    }

    public int getTag() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Tag not yet read.");
        }
        TLVStruct currentObject = this.state.peek();
        return currentObject.getTag();
    }

    public int getLength() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Length not yet known.");
        }
        TLVStruct currentObject = this.state.peek();
        int length = currentObject.getLength();
        if (length < 0) {
            throw new IllegalStateException("Length not yet knwon.");
        }
        return length;
    }

    public int getValueBytesProcessed() {
        TLVStruct currentObject = this.state.peek();
        return currentObject.getValueBytesProcessed();
    }

    public int getValueBytesLeft() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Length of value is unknown.");
        }
        TLVStruct currentObject = this.state.peek();
        int currentLength = currentObject.getLength();
        int valueBytesRead = currentObject.getValueBytesProcessed();
        return currentLength - valueBytesRead;
    }

    public void setTagProcessed(int tag) {
        TLVStruct obj = new TLVStruct(tag);
        if (!this.state.isEmpty()) {
            TLVStruct parent = this.state.peek();
            byte[] tagBytes = TLVUtil.getTagAsBytes(tag);
            parent.write(tagBytes, 0, tagBytes.length);
        }
        this.state.push(obj);
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = true;
        this.isReadingValue = false;
    }

    public void setDummyLengthProcessed() {
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = false;
        this.isReadingValue = true;
    }

    public boolean isDummyLengthSet() {
        if (this.state.isEmpty()) {
            return false;
        }
        return !this.state.peek().isLengthSet();
    }

    public void setLengthProcessed(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Cannot set negative length (length = " + length + ").");
        }
        TLVStruct obj = this.state.pop();
        if (!this.state.isEmpty()) {
            TLVStruct parent = this.state.peek();
            byte[] lengthBytes = TLVUtil.getLengthAsBytes(length);
            parent.write(lengthBytes, 0, lengthBytes.length);
        }
        obj.setLength(length);
        this.state.push(obj);
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = false;
        this.isReadingValue = true;
    }

    public void updatePreviousLength(int byteCount) {
        if (this.state.isEmpty()) {
            return;
        }
        TLVStruct currentObject = this.state.peek();
        if (currentObject.isLengthSet && currentObject.getLength() == byteCount) {
            return;
        }
        currentObject.setLength(byteCount);
        if (currentObject.getValueBytesProcessed() == currentObject.getLength()) {
            this.state.pop();
            byte[] lengthBytes = TLVUtil.getLengthAsBytes(byteCount);
            byte[] value = currentObject.getValue();
            this.updateValueBytesProcessed(lengthBytes, 0, lengthBytes.length);
            this.updateValueBytesProcessed(value, 0, value.length);
            this.isAtStartOfTag = true;
            this.isAtStartOfLength = false;
            this.isReadingValue = false;
        }
    }

    public void updateValueBytesProcessed(byte[] bytes, int offset, int length) {
        if (this.state.isEmpty()) {
            return;
        }
        TLVStruct currentObject = this.state.peek();
        int bytesLeft = currentObject.getLength() - currentObject.getValueBytesProcessed();
        if (length > bytesLeft) {
            throw new IllegalArgumentException("Cannot process " + length + " bytes! Only " + bytesLeft + " bytes left in this TLV object " + currentObject);
        }
        currentObject.write(bytes, offset, length);
        if (currentObject.getValueBytesProcessed() == currentObject.getLength()) {
            this.state.pop();
            this.updateValueBytesProcessed(currentObject.getValue(), 0, currentObject.getLength());
            this.isAtStartOfTag = true;
            this.isAtStartOfLength = false;
            this.isReadingValue = false;
        } else {
            this.isAtStartOfTag = false;
            this.isAtStartOfLength = false;
            this.isReadingValue = true;
        }
    }

    public byte[] getValue() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Cannot get value yet.");
        }
        return this.state.peek().getValue();
    }

    public Object clone() {
        return new TLVOutputState((Stack)this.state.clone(), this.isAtStartOfTag, this.isAtStartOfLength, this.isReadingValue);
    }

    public String toString() {
        return this.state.toString();
    }

    public boolean canBeWritten() {
        for (TLVStruct stackFrame : this.state) {
            if (stackFrame.isLengthSet()) continue;
            return false;
        }
        return true;
    }

    private class TLVStruct
    implements Cloneable {
        private int tag;
        private int length;
        private boolean isLengthSet;
        private ByteArrayOutputStream value;

        public TLVStruct(int tag) {
            this.tag = tag;
            this.length = Integer.MAX_VALUE;
            this.isLengthSet = false;
            this.value = new ByteArrayOutputStream();
        }

        public void setLength(int length) {
            this.length = length;
            this.isLengthSet = true;
        }

        public int getTag() {
            return this.tag;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isLengthSet() {
            return this.isLengthSet;
        }

        public int getValueBytesProcessed() {
            return this.value.size();
        }

        public byte[] getValue() {
            return this.value.toByteArray();
        }

        public void write(byte[] bytes, int offset, int length) {
            this.value.write(bytes, offset, length);
        }

        public Object clone() {
            TLVStruct copy = new TLVStruct(this.tag);
            copy.length = this.length;
            copy.value = new ByteArrayOutputStream();
            try {
                copy.value.write(this.value.toByteArray());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return copy;
        }

        public String toString() {
            byte[] valueBytes = this.value.toByteArray();
            return "[TLVStruct " + Integer.toHexString(this.tag) + ", " + (this.isLengthSet ? Integer.valueOf(this.length) : "UNDEFINED") + ", " + Hex.bytesToHexString(valueBytes) + "(" + valueBytes.length + ") ]";
        }
    }
}

