/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.scuba.tlv.TLVInputState;
import net.sf.scuba.tlv.TLVUtil;

public class TLVInputStream
extends InputStream {
    private static final int MAX_BUFFER_LENGTH = 65535;
    private final InputStream originalInputStream;
    private DataInputStream inputStream;
    private int bufferSize = 0;
    private TLVInputState state;
    private TLVInputState markedState;

    public TLVInputStream(InputStream inputStream) {
        try {
            if (inputStream instanceof BufferedInputStream || inputStream instanceof ByteArrayInputStream) {
                this.bufferSize = inputStream.available();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.originalInputStream = inputStream;
        this.inputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        this.state = new TLVInputState();
        this.markedState = null;
    }

    public int readTag() throws IOException {
        if (!this.state.isAtStartOfTag() && !this.state.isProcessingValue()) {
            throw new IllegalStateException("Not at start of tag");
        }
        int tag = -1;
        int bytesRead = 0;
        int b = this.inputStream.readUnsignedByte();
        ++bytesRead;
        while (b == 0 || b == 255) {
            b = this.inputStream.readUnsignedByte();
            ++bytesRead;
        }
        switch (b & 0x1F) {
            case 31: {
                tag = b;
                b = this.inputStream.readUnsignedByte();
                ++bytesRead;
                while ((b & 0x80) == 128) {
                    tag <<= 8;
                    tag |= b & 0x7F;
                    b = this.inputStream.readUnsignedByte();
                    ++bytesRead;
                }
                tag <<= 8;
                tag |= b & 0x7F;
                break;
            }
            default: {
                tag = b;
            }
        }
        this.state.setTagProcessed(tag, bytesRead);
        return tag;
    }

    public int readLength() throws IOException {
        if (!this.state.isAtStartOfLength()) {
            throw new IllegalStateException("Not at start of length");
        }
        int bytesRead = 0;
        int length = 0;
        int b = this.inputStream.readUnsignedByte();
        ++bytesRead;
        if ((b & 0x80) == 0) {
            length = b;
        } else {
            int count = b & 0x7F;
            length = 0;
            for (int i = 0; i < count; ++i) {
                b = this.inputStream.readUnsignedByte();
                ++bytesRead;
                length <<= 8;
                length |= b;
            }
        }
        this.state.setLengthProcessed(length, bytesRead);
        return length;
    }

    public byte[] readValue() throws IOException {
        if (!this.state.isProcessingValue()) {
            throw new IllegalStateException("Not yet processing value!");
        }
        int length = this.state.getLength();
        byte[] value = new byte[length];
        this.inputStream.readFully(value);
        this.state.updateValueBytesProcessed(length);
        return value;
    }

    private long skipValue() throws IOException {
        if (this.state.isAtStartOfTag()) {
            return 0L;
        }
        if (this.state.isAtStartOfLength()) {
            return 0L;
        }
        int bytesLeft = this.state.getValueBytesLeft();
        return this.skip(bytesLeft);
    }

    public void skipToTag(int searchTag) throws IOException {
        while (true) {
            int tag = -1;
            if (!this.state.isAtStartOfTag()) {
                if (this.state.isAtStartOfLength()) {
                    this.readLength();
                    if (TLVUtil.isPrimitive(this.state.getTag())) {
                        this.skipValue();
                    }
                } else if (TLVUtil.isPrimitive(this.state.getTag())) {
                    this.skipValue();
                }
            }
            if ((tag = this.readTag()) == searchTag) {
                return;
            }
            if (!TLVUtil.isPrimitive(tag)) continue;
            int length = this.readLength();
            int skippedBytes = (int)this.skipValue();
            if (skippedBytes < length) break;
        }
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public int read() throws IOException {
        int result = this.inputStream.read();
        if (result < 0) {
            return -1;
        }
        this.state.updateValueBytesProcessed(1);
        return result;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long result = this.inputStream.skip(n);
        this.state.updateValueBytesProcessed((int)result);
        return result;
    }

    public synchronized void mark(int readLimit) {
        this.inputStream.mark(readLimit);
        this.markedState = (TLVInputState)this.state.clone();
    }

    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public synchronized void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("mark/reset not supported");
        }
        this.inputStream.reset();
        this.state = this.markedState;
        this.markedState = null;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public String toString() {
        return this.state.toString();
    }
}

