/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import java.math.BigInteger;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.FileInfo;
import net.sf.scuba.util.Hex;

public class ISOFileInfo
extends FileInfo {
    public static final byte FCI_BYTE = 111;
    public static final byte FMD_BYTE = 100;
    public static final byte FCP_BYTE = 98;
    public static final byte DATA_BYTES1 = -128;
    public static final byte DATA_BYTES2 = -127;
    public static final byte FILE_DESCRIPTOR = -126;
    public static final byte FILE_IDENTIFIER = -125;
    public static final byte DF_NAME = -124;
    public static final byte PROP_INFO = -123;
    public static final byte SECURITY_ATTR_PROP = -122;
    public static final byte FCI_EXT = -121;
    public static final byte SHORT_EF = -120;
    public static final byte LCS_BYTE = -118;
    public static final byte SECURITY_ATTR_EXP = -117;
    public static final byte SECURITY_ATTR_COMPACT = -116;
    public static final byte ENV_TEMP_EF = -115;
    public static final byte CHANNEL_SECURITY = -114;
    public static final byte A0 = -96;
    public static final byte A1 = -95;
    public static final byte A2 = -94;
    public static final byte A5 = -91;
    public static final byte AB = -85;
    public static final byte AC = -84;
    byte mainTag = (byte)-1;
    int fileLength = -1;
    int fileLengthFCI = -1;
    byte descriptorByte = (byte)-1;
    byte dataCodingByte = (byte)-1;
    short maxRecordSize = (short)-1;
    short maxRecordsCount = (short)-1;
    short fid = (short)-1;
    byte[] dfName = null;
    byte[] propInfo = null;
    byte[] secAttrProp = null;
    byte[] secAttrExp = null;
    byte[] secAttrCompact = null;
    short fciExt = (short)-1;
    short envTempEF = (short)-1;
    byte shortEF = (byte)-1;
    byte lcsByte = (byte)-1;
    byte channelSecurity = (byte)-1;
    byte[] a0 = null;
    byte[] a1 = null;
    byte[] a2 = null;
    byte[] a5 = null;
    byte[] ab = null;
    byte[] ac = null;

    public ISOFileInfo(byte[] fileInfo) throws CardServiceException {
        if (fileInfo.length == 0) {
            return;
        }
        if (fileInfo[0] != 111 && fileInfo[0] != 98 && fileInfo[0] != 100) {
            throw new CardServiceException("Malformed FCI data");
        }
        this.mainTag = fileInfo[0];
        byte[] tmp = new byte[fileInfo[1]];
        System.arraycopy(fileInfo, 2, tmp, 0, fileInfo[1]);
        fileInfo = tmp;
        int offset = 0;
        BigInteger integer = null;
        int off = 0;
        try {
            while (offset < fileInfo.length) {
                byte tag = fileInfo[offset++];
                byte len = fileInfo[offset++];
                byte[] contents = new byte[len];
                System.arraycopy(fileInfo, offset, contents, 0, len);
                offset += len;
                switch (tag) {
                    case -128: {
                        integer = new BigInteger(contents);
                        integer = integer.abs();
                        this.fileLength = integer.intValue();
                        break;
                    }
                    case -127: {
                        ISOFileInfo.checkLen(len, 2);
                        integer = new BigInteger(contents);
                        this.fileLengthFCI = integer.intValue();
                        break;
                    }
                    case -126: {
                        ISOFileInfo.checkLen(len, 1, 6);
                        off = 0;
                        this.descriptorByte = contents[off++];
                        if (off == contents.length) break;
                        this.dataCodingByte = contents[off++];
                        if (off == contents.length) break;
                        if (contents.length == 3) {
                            this.maxRecordSize = contents[off++];
                        } else {
                            integer = new BigInteger(new byte[]{contents[off++], contents[off++]});
                            this.maxRecordSize = integer.shortValue();
                        }
                        if (off == contents.length) break;
                        if (contents.length == 5) {
                            this.maxRecordsCount = contents[off++];
                            break;
                        }
                        integer = new BigInteger(new byte[]{contents[off++], contents[off++]});
                        this.maxRecordsCount = integer.shortValue();
                        break;
                    }
                    case -125: {
                        ISOFileInfo.checkLen(len, 2);
                        integer = new BigInteger(contents);
                        this.fid = integer.shortValue();
                        break;
                    }
                    case -124: {
                        ISOFileInfo.checkLen(len, 0, 16);
                        this.dfName = new byte[contents.length];
                        System.arraycopy(contents, 0, this.dfName, 0, contents.length);
                        break;
                    }
                    case -123: {
                        this.propInfo = new byte[contents.length];
                        System.arraycopy(contents, 0, this.propInfo, 0, contents.length);
                        break;
                    }
                    case -122: {
                        this.secAttrProp = new byte[contents.length];
                        System.arraycopy(contents, 0, this.secAttrProp, 0, contents.length);
                        break;
                    }
                    case -121: {
                        ISOFileInfo.checkLen(len, 2);
                        integer = new BigInteger(contents);
                        this.fciExt = integer.shortValue();
                        break;
                    }
                    case -120: {
                        ISOFileInfo.checkLen(len, 0, 1);
                        if (len == 0) {
                            this.shortEF = 0;
                            break;
                        }
                        this.shortEF = contents[0];
                        break;
                    }
                    case -118: {
                        ISOFileInfo.checkLen(len, 1);
                        this.lcsByte = contents[0];
                        break;
                    }
                    case -117: {
                        this.secAttrExp = new byte[contents.length];
                        System.arraycopy(contents, 0, this.secAttrExp, 0, contents.length);
                        break;
                    }
                    case -116: {
                        this.secAttrCompact = new byte[contents.length];
                        System.arraycopy(contents, 0, this.secAttrCompact, 0, contents.length);
                        break;
                    }
                    case -115: {
                        ISOFileInfo.checkLen(len, 2);
                        integer = new BigInteger(contents);
                        this.envTempEF = integer.shortValue();
                        break;
                    }
                    case -114: {
                        ISOFileInfo.checkLen(len, 1);
                        this.channelSecurity = contents[0];
                        break;
                    }
                    case -96: {
                        this.a0 = new byte[contents.length];
                        System.arraycopy(contents, 0, this.a0, 0, contents.length);
                        break;
                    }
                    case -95: {
                        this.a1 = new byte[contents.length];
                        System.arraycopy(contents, 0, this.a1, 0, contents.length);
                        break;
                    }
                    case -94: {
                        this.a2 = new byte[contents.length];
                        System.arraycopy(contents, 0, this.a2, 0, contents.length);
                        break;
                    }
                    case -91: {
                        this.a5 = new byte[contents.length];
                        System.arraycopy(contents, 0, this.a5, 0, contents.length);
                        break;
                    }
                    case -85: {
                        this.ab = new byte[contents.length];
                        System.arraycopy(contents, 0, this.ab, 0, contents.length);
                        break;
                    }
                    case -84: {
                        this.ac = new byte[contents.length];
                        System.arraycopy(contents, 0, this.ac, 0, contents.length);
                        break;
                    }
                    default: {
                        throw new CardServiceException("Malformed FCI: unrecognized tag.");
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new CardServiceException("Malformed FCI.");
        }
    }

    private static void checkLen(int len, int value) throws CardServiceException {
        if (len != value) {
            throw new CardServiceException("Malformed FCI.");
        }
    }

    private static void checkLen(int len, int minValue, int maxValue) throws CardServiceException {
        if (len < minValue || len > maxValue) {
            throw new CardServiceException("Malformed FCI.");
        }
    }

    public byte[] getFormatted() {
        byte[] result = new byte[]{};
        if (this.mainTag == -1) {
            return result;
        }
        byte[] piece = null;
        if (this.fileLength != -1) {
            piece = ISOFileInfo.getArray((byte)-128, Hex.hexStringToBytes(Hex.shortToHexString((short)this.fileLength)));
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.fileLengthFCI != -1) {
            piece = ISOFileInfo.getArray((byte)-127, Hex.hexStringToBytes(Hex.shortToHexString((short)this.fileLengthFCI)));
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.descriptorByte != -1) {
            byte[] ar1 = new byte[]{this.descriptorByte};
            byte[] ar2 = new byte[]{};
            if (this.dataCodingByte != -1) {
                ar2 = new byte[]{this.dataCodingByte};
            }
            byte[] ar3 = new byte[]{};
            if (this.maxRecordSize != -1) {
                String x = null;
                x = this.maxRecordSize <= 256 ? (this.maxRecordsCount == -1 ? Hex.byteToHexString((byte)this.maxRecordSize) : Hex.shortToHexString(this.maxRecordSize)) : Hex.shortToHexString(this.maxRecordSize);
                ar3 = Hex.hexStringToBytes(x);
            }
            byte[] ar4 = new byte[]{};
            if (this.maxRecordsCount != -1) {
                String x = null;
                x = this.maxRecordsCount <= 256 ? Hex.byteToHexString((byte)this.maxRecordsCount) : Hex.shortToHexString(this.maxRecordsCount);
                ar4 = Hex.hexStringToBytes(x);
            }
            piece = ISOFileInfo.getArray((byte)-126, ISOFileInfo.catArray(ISOFileInfo.catArray(ISOFileInfo.catArray(ar1, ar2), ar3), ar4));
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.fid != -1) {
            piece = ISOFileInfo.getArray((byte)-125, Hex.hexStringToBytes(Hex.shortToHexString(this.fid)));
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.dfName != null) {
            piece = ISOFileInfo.getArray((byte)-124, this.dfName);
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.propInfo != null) {
            piece = ISOFileInfo.getArray((byte)-123, this.propInfo);
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.secAttrProp != null) {
            piece = ISOFileInfo.getArray((byte)-122, this.secAttrProp);
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.fciExt != -1) {
            piece = ISOFileInfo.getArray((byte)-121, Hex.hexStringToBytes(Hex.shortToHexString(this.fciExt)));
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.shortEF != -1) {
            byte[] byArray;
            if (this.shortEF == 0) {
                byArray = new byte[]{};
            } else {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = this.shortEF;
            }
            piece = ISOFileInfo.getArray((byte)-120, byArray);
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.lcsByte != -1) {
            piece = ISOFileInfo.getArray((byte)-118, new byte[]{this.lcsByte});
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.secAttrExp != null) {
            piece = ISOFileInfo.getArray((byte)-117, this.secAttrExp);
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.secAttrCompact != null) {
            piece = ISOFileInfo.getArray((byte)-116, this.secAttrCompact);
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.envTempEF != -1) {
            piece = ISOFileInfo.getArray((byte)-115, Hex.hexStringToBytes(Hex.shortToHexString(this.envTempEF)));
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.channelSecurity != -1) {
            piece = ISOFileInfo.getArray((byte)-114, new byte[]{this.channelSecurity});
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.a0 != null) {
            piece = ISOFileInfo.getArray((byte)-96, this.a0);
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.a1 != null) {
            piece = ISOFileInfo.getArray((byte)-95, this.a1);
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.a2 != null) {
            piece = ISOFileInfo.getArray((byte)-94, this.a2);
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.a5 != null) {
            piece = ISOFileInfo.getArray((byte)-91, this.a5);
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.ab != null) {
            piece = ISOFileInfo.getArray((byte)-85, this.ab);
            result = ISOFileInfo.catArray(result, piece);
        }
        if (this.ac != null) {
            piece = ISOFileInfo.getArray((byte)-84, this.ac);
            result = ISOFileInfo.catArray(result, piece);
        }
        return ISOFileInfo.getArray(this.mainTag, result);
    }

    private static byte[] getArray(byte tag, byte[] contents) {
        byte[] result = new byte[contents.length + 2];
        result[0] = tag;
        result[1] = (byte)contents.length;
        System.arraycopy(contents, 0, result, 2, contents.length);
        return result;
    }

    private static byte[] catArray(byte[] a1, byte[] a2) {
        byte[] result = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public String toString() {
        return "Length: " + this.fileLength + "\nLength FCI: " + this.fileLengthFCI + "\nDesc byte: " + this.descriptorByte + "\nData byte: " + this.dataCodingByte + "\nRecord size: " + this.maxRecordSize + "\nRecord count: " + this.maxRecordsCount + "\nFID: " + Hex.shortToHexString(this.fid) + "\nDF name: " + Hex.bytesToHexString(this.dfName) + "\npropInfo: " + Hex.bytesToHexString(this.propInfo) + "\nsecAttrProp: " + Hex.bytesToHexString(this.secAttrProp) + "\nsecAttrExp: " + Hex.bytesToHexString(this.secAttrExp) + "\nsecAttrComp: " + Hex.bytesToHexString(this.secAttrCompact) + "\nFCI ext: " + Hex.shortToHexString(this.fciExt) + "\nEF env temp: " + Hex.shortToHexString(this.envTempEF) + "\nShort EF: " + Hex.byteToHexString(this.shortEF) + "\nLCS byte: " + Hex.byteToHexString(this.lcsByte) + "\nChannel sec: " + Hex.byteToHexString(this.channelSecurity) + "\na0: " + Hex.bytesToHexString(this.a0) + "\na1: " + Hex.bytesToHexString(this.a1) + "\na2: " + Hex.bytesToHexString(this.a2) + "\na5: " + Hex.bytesToHexString(this.a5) + "\nab: " + Hex.bytesToHexString(this.ab) + "\nac: " + Hex.bytesToHexString(this.ac) + "\n";
    }

    public short getFID() {
        return this.fid;
    }

    public int getFileLength() {
        return this.fileLength;
    }
}

