/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.io.ByteArrayOutputStream;
import net.sf.scuba.tlv.ASN1Constants;

public class TLVUtil
implements ASN1Constants {
    private TLVUtil() {
    }

    public static boolean isPrimitive(int tag) {
        int mask;
        int i;
        for (i = 3; i >= 0 && (tag & (mask = 255 << 8 * i)) == 0; --i) {
        }
        int msByte = (tag & 255 << 8 * i) >> 8 * i & 0xFF;
        boolean result = (msByte & 0x20) == 0;
        return result;
    }

    public static int getTagLength(int tag) {
        return TLVUtil.getTagAsBytes(tag).length;
    }

    public static int getLengthLength(int length) {
        return TLVUtil.getLengthAsBytes(length).length;
    }

    public static byte[] getTagAsBytes(int tag) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int byteCount = (int)(Math.log(tag) / Math.log(256.0)) + 1;
        for (int i = 0; i < byteCount; ++i) {
            int pos = 8 * (byteCount - i - 1);
            out.write((tag & 255 << pos) >> pos);
        }
        byte[] tagBytes = out.toByteArray();
        switch (TLVUtil.getTagClass(tag)) {
            case 1: {
                tagBytes[0] = (byte)(tagBytes[0] | 0x40);
                break;
            }
            case 2: {
                tagBytes[0] = (byte)(tagBytes[0] | 0x80);
                break;
            }
            case 3: {
                tagBytes[0] = (byte)(tagBytes[0] | 0xC0);
            }
        }
        if (!TLVUtil.isPrimitive(tag)) {
            tagBytes[0] = (byte)(tagBytes[0] | 0x20);
        }
        return tagBytes;
    }

    public static byte[] getLengthAsBytes(int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (length < 128) {
            out.write(length);
        } else {
            int byteCount = TLVUtil.log(length, 256);
            out.write(0x80 | byteCount);
            for (int i = 0; i < byteCount; ++i) {
                int pos = 8 * (byteCount - i - 1);
                out.write((length & 255 << pos) >> pos);
            }
        }
        return out.toByteArray();
    }

    static int getTagClass(int tag) {
        int mask;
        int i;
        for (i = 3; i >= 0 && (tag & (mask = 255 << 8 * i)) == 0; --i) {
        }
        int msByte = (tag & 255 << 8 * i) >> 8 * i & 0xFF;
        switch (msByte & 0xC0) {
            case 0: {
                return 0;
            }
            case 64: {
                return 1;
            }
            case 128: {
                return 2;
            }
        }
        return 3;
    }

    private static int log(int n, int base) {
        int result = 0;
        while (n > 0) {
            n /= base;
            ++result;
        }
        return result;
    }
}

