/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.tlv.ASN1Constants;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;

public class TLVUtil
implements ASN1Constants {
    private static final Logger LOGGER = Logger.getLogger("net.sf.scuba");

    private TLVUtil() {
    }

    public static boolean isPrimitive(int tag) {
        int mask;
        int i;
        for (i = 3; i >= 0 && (tag & (mask = 255 << 8 * i)) == 0; --i) {
        }
        int msByte = (tag & 255 << 8 * i) >> 8 * i & 0xFF;
        return (msByte & 0x20) == 0;
    }

    public static int getTagLength(int tag) {
        return TLVUtil.getTagAsBytes(tag).length;
    }

    public static int getLengthLength(int length) {
        return TLVUtil.getLengthAsBytes(length).length;
    }

    public static byte[] getTagAsBytes(int tag) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int byteCount = (int)(Math.log(tag) / Math.log(256.0)) + 1;
        for (int i = 0; i < byteCount; ++i) {
            int pos = 8 * (byteCount - i - 1);
            out.write((tag & 255 << pos) >> pos);
        }
        byte[] tagBytes = out.toByteArray();
        switch (TLVUtil.getTagClass(tag)) {
            case 1: {
                tagBytes[0] = (byte)(tagBytes[0] | 0x40);
                break;
            }
            case 2: {
                tagBytes[0] = (byte)(tagBytes[0] | 0x80);
                break;
            }
            case 3: {
                tagBytes[0] = (byte)(tagBytes[0] | 0xC0);
                break;
            }
        }
        if (!TLVUtil.isPrimitive(tag)) {
            tagBytes[0] = (byte)(tagBytes[0] | 0x20);
        }
        return tagBytes;
    }

    public static byte[] getLengthAsBytes(int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (length < 128) {
            out.write(length);
        } else {
            int byteCount = TLVUtil.log(length, 256);
            out.write(0x80 | byteCount);
            for (int i = 0; i < byteCount; ++i) {
                int pos = 8 * (byteCount - i - 1);
                out.write((length & 255 << pos) >> pos);
            }
        }
        return out.toByteArray();
    }

    public static byte[] wrapDO(int tag, byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data to wrap is null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            TLVOutputStream tlvOutputStream = new TLVOutputStream(byteArrayOutputStream);
            tlvOutputStream.writeTag(tag);
            tlvOutputStream.writeValue(data);
            tlvOutputStream.flush();
            tlvOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing stream", ioe);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Error closing stream", ioe);
            }
        }
    }

    public static byte[] unwrapDO(int expectedTag, byte[] wrappedData) {
        if (wrappedData == null || wrappedData.length < 2) {
            throw new IllegalArgumentException("Wrapped data is null or length < 2");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(wrappedData);
        TLVInputStream tlvInputStream = new TLVInputStream(byteArrayInputStream);
        try {
            int actualTag = tlvInputStream.readTag();
            if (actualTag != expectedTag) {
                throw new IllegalArgumentException("Expected tag " + Integer.toHexString(expectedTag) + ", found tag " + Integer.toHexString(actualTag));
            }
            int length = tlvInputStream.readLength();
            byte[] value = tlvInputStream.readValue();
            byte[] result = new byte[length];
            System.arraycopy(value, 0, result, 0, length);
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error reading from stream", ioe);
        }
        finally {
            try {
                tlvInputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Error closing stream", ioe);
            }
        }
    }

    static int getTagClass(int tag) {
        int mask;
        int i;
        for (i = 3; i >= 0 && (tag & (mask = 255 << 8 * i)) == 0; --i) {
        }
        int msByte = (tag & 255 << 8 * i) >> 8 * i & 0xFF;
        switch (msByte & 0xC0) {
            case 0: {
                return 0;
            }
            case 64: {
                return 1;
            }
            case 128: {
                return 2;
            }
        }
        return 3;
    }

    private static int log(int n, int base) {
        int result = 0;
        while (n > 0) {
            n /= base;
            ++result;
        }
        return result;
    }
}

