/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.util;

public final class Hex {
    private static final String HEXCHARS = "0123456789abcdefABCDEF";
    private static final String PRINTABLE = " .,:;'`\"<>()[]{}?/\\!@#$%^&*_-=+|~0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final boolean LEFT = true;
    private static final boolean RIGHT = false;

    private Hex() {
    }

    public static String byteToHexString(byte b) {
        int n = b & 0xFF;
        String result = (n < 16 ? "0" : "") + Integer.toHexString(n);
        return result.toUpperCase();
    }

    public static String shortToHexString(short s) {
        int n = s & 0xFFFF;
        String result = (n < 4096 ? "0" : "") + (n < 256 ? "0" : "") + (n < 16 ? "0" : "") + Integer.toHexString(s);
        if (result.length() > 4) {
            result = result.substring(result.length() - 4, result.length());
        }
        return result.toUpperCase();
    }

    public static String intToHexString(int n) {
        return ((n < 0x10000000 ? "0" : "") + (n < 0x1000000 ? "0" : "") + (n < 0x100000 ? "0" : "") + (n < 65536 ? "0" : "") + (n < 4096 ? "0" : "") + (n < 256 ? "0" : "") + (n < 16 ? "0" : "") + Integer.toHexString(n)).toUpperCase();
    }

    public static String bytesToHexString(byte[] text) {
        return Hex.bytesToHexString(text, 1000);
    }

    public static String bytesToHexString(byte[] text, int numRow) {
        if (text == null) {
            return "NULL";
        }
        return Hex.bytesToHexString(text, 0, text.length, numRow);
    }

    public static String toHexString(byte[] text) {
        return Hex.bytesToHexString(text, 0, text.length, 1000);
    }

    public static String toHexString(byte[] text, int numRow) {
        return Hex.bytesToHexString(text, 0, text.length, numRow);
    }

    public static String bytesToHexString(byte[] text, int offset, int length, int numRow) {
        if (text == null) {
            return "NULL";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i != 0 && i % numRow == 0) {
                result.append("\n");
            }
            result.append(Hex.byteToHexString(text[offset + i]));
        }
        return result.toString();
    }

    public static String bytesToHexString(byte[] text, int offset, int length) {
        return Hex.bytesToHexString(text, offset, length, 1000);
    }

    public static byte hexStringToByte(String text) throws NumberFormatException {
        byte[] bytes = Hex.hexStringToBytes(text);
        if (bytes == null || bytes.length != 1) {
            throw new NumberFormatException();
        }
        return bytes[0];
    }

    public static short hexStringToShort(String text) throws NumberFormatException {
        byte[] bytes = Hex.hexStringToBytes(text);
        if (bytes == null || bytes.length != 2) {
            throw new NumberFormatException();
        }
        return (short)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
    }

    public static int hexStringToInt(String text) throws NumberFormatException {
        byte[] bytes = Hex.hexStringToBytes(text);
        if (bytes == null || bytes.length != 4) {
            throw new NumberFormatException();
        }
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static byte[] hexStringToBytes(String text) throws NumberFormatException {
        if (text == null) {
            return null;
        }
        StringBuilder hexText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (HEXCHARS.indexOf(c) < 0) {
                throw new NumberFormatException();
            }
            hexText.append(c);
        }
        if (hexText.length() % 2 != 0) {
            hexText.insert(0, "0");
        }
        byte[] result = new byte[hexText.length() / 2];
        for (int i = 0; i < hexText.length(); i += 2) {
            int hi = Hex.hexDigitToInt(hexText.charAt(i));
            int lo = Hex.hexDigitToInt(hexText.charAt(i + 1));
            result[i / 2] = (byte)((hi & 0xFF) << 4 | lo & 0xFF);
        }
        return result;
    }

    static int hexDigitToInt(char c) throws NumberFormatException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new NumberFormatException();
    }

    private static String pad(String txt, int width, char padChar, boolean left) {
        StringBuilder result = new StringBuilder();
        int txtLength = txt.length();
        if (txtLength >= width) {
            return txt;
        }
        int padLength = width - txtLength;
        for (int i = 0; i < padLength; ++i) {
            result.append(padChar);
        }
        if (left) {
            return result.append(txt).toString();
        }
        return txt + result.toString();
    }

    public static String bytesToSpacedHexString(byte[] data) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            result.append(Hex.byteToHexString(data[i]));
            result.append(i < data.length - 1 ? " " : "");
        }
        return result.toString().toUpperCase();
    }

    private static String[] bytesToSpacedHexStrings(byte[] data, int columns, int padWidth) {
        byte[][] src = Hex.split(data, columns);
        String[] result = new String[src.length];
        for (int j = 0; j < src.length; ++j) {
            result[j] = Hex.pad(Hex.bytesToSpacedHexString(src[j]), padWidth, ' ', false);
        }
        return result;
    }

    public static String bytesToASCIIString(byte[] data) {
        StringBuilder result = new StringBuilder();
        for (byte element : data) {
            char c = (char)element;
            result.append(Character.toString(PRINTABLE.indexOf(c) >= 0 ? c : (char)'.'));
        }
        return result.toString();
    }

    static String[] bytesToASCIIStrings(byte[] data, int columns) {
        byte[][] src = Hex.split(data, columns);
        String[] result = new String[src.length];
        for (int j = 0; j < src.length; ++j) {
            result[j] = Hex.bytesToASCIIString(src[j]);
        }
        return result;
    }

    public static byte[][] split(byte[] src, int width) {
        int rows = src.length / width;
        int rest = src.length % width;
        byte[][] dest = new byte[rows + (rest > 0 ? 1 : 0)][];
        int k = 0;
        for (int j = 0; j < rows; ++j) {
            dest[j] = new byte[width];
            System.arraycopy(src, k, dest[j], 0, width);
            k += width;
        }
        if (rest > 0) {
            dest[rows] = new byte[rest];
            System.arraycopy(src, k, dest[rows], 0, rest);
        }
        return dest;
    }

    public static String bytesToPrettyString(byte[] data) {
        return Hex.bytesToPrettyString(data, 16, true, 4, null, true);
    }

    public static String bytesToPrettyString(byte[] data, int columns, boolean useIndex, int indexPadWidth, String altIndex, boolean useASCII) {
        StringBuilder result = new StringBuilder();
        String[] hexStrings = Hex.bytesToSpacedHexStrings(data, columns, 3 * columns);
        String[] asciiStrings = Hex.bytesToASCIIStrings(data, columns);
        for (int j = 0; j < hexStrings.length; ++j) {
            String prefix;
            if (useIndex) {
                prefix = Integer.toHexString(j * columns).toUpperCase();
                result.append(Hex.pad(prefix, indexPadWidth, '0', true) + ": ");
            } else {
                prefix = j == 0 ? altIndex : "";
                result.append(Hex.pad(prefix, indexPadWidth, ' ', true) + " ");
            }
            result.append(hexStrings[j]);
            if (useASCII) {
                result.append(" " + asciiStrings[j]);
            }
            result.append("\n");
        }
        return result.toString();
    }
}

