/*
 * This file is part of the SCUBA smart card framework.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (C) 2009 - 2018  The SCUBA team.
 *
 * $Id: APDUWrapper.java 302 2018-01-13 23:54:51Z martijno $
 */

package net.sf.scuba.smartcards;

/**
 * Wrapper interface for command APDU wrapping.
 *
 * @author Cees-Bart Breunesse (ceesb@cs.ru.nl)
 * @author Martijn Oostdijk (martijno@cs.ru.nl)
 *
 * @version $Revision: 302 $
 */
public interface APDUWrapper {

  /**
   * An indication of the type of wrapper.
   *
   * @return the type of wrapper
   */
  String getType();

  /**
   * Wraps the command APDU buffer.
   *
   * @param capdu the command APDU
   *
   * @return the wrapped APDU
   */
  CommandAPDU wrap(CommandAPDU capdu);

  /**
   * Unwraps the response APDU buffer.
   *
   * @param rapdu the response APDU
   *
   * @return the wrapped APDU
   */
  ResponseAPDU unwrap(ResponseAPDU rapdu);
}
