/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.FileInfo;
import net.sf.scuba.smartcards.FileSystemStructured;

public class CardFileInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger("net.sf.scuba");
    private FileInfo[] path;
    private final byte[] buffer;
    private int bufferLength;
    private int offsetBufferInFile;
    private int offsetInBuffer;
    private int markedOffset;
    private int fileLength;
    private FileSystemStructured fs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardFileInputStream(int maxBlockSize, FileSystemStructured fs) throws CardServiceException {
        FileSystemStructured fileSystemStructured = this.fs = fs;
        synchronized (fileSystemStructured) {
            Object[] fsPath = fs.getSelectedPath();
            if (fsPath == null || fsPath.length < 1) {
                throw new CardServiceException("No valid file selected, path = " + Arrays.toString(fsPath));
            }
            this.path = new FileInfo[fsPath.length];
            System.arraycopy(fsPath, 0, this.path, 0, fsPath.length);
            this.fileLength = ((FileInfo)fsPath[fsPath.length - 1]).getFileLength();
            this.buffer = new byte[maxBlockSize];
            this.bufferLength = 0;
            this.offsetBufferInFile = 0;
            this.offsetInBuffer = 0;
            this.markedOffset = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            try {
                if (!Arrays.equals(this.path, this.fs.getSelectedPath())) {
                    for (FileInfo fileInfo : this.path) {
                        this.fs.selectFile(fileInfo.getFID());
                    }
                }
            }
            catch (CardServiceException cse) {
                LOGGER.log(Level.WARNING, "Unexpected exception", cse);
                throw new IOException("Unexpected exception", cse);
            }
            int offsetInFile = this.offsetBufferInFile + this.offsetInBuffer;
            if (offsetInFile >= this.fileLength) {
                return -1;
            }
            if (this.offsetInBuffer >= this.bufferLength) {
                int le = Math.min(this.buffer.length, this.fileLength - offsetInFile);
                try {
                    int newOffsetBufferInFile = this.offsetBufferInFile + this.bufferLength;
                    int newOffsetInBuffer = 0;
                    int newBufferLength = this.fillBufferFromFile(this.path, newOffsetBufferInFile, le);
                    this.offsetBufferInFile = newOffsetBufferInFile;
                    this.offsetInBuffer = newOffsetInBuffer;
                    this.bufferLength = newBufferLength;
                }
                catch (CardServiceException cse) {
                    throw new IOException("Unexpected exception", cse);
                }
                catch (Exception e) {
                    throw new IOException("Unexpected exception", e);
                }
            }
            int result = this.buffer[this.offsetInBuffer] & 0xFF;
            ++this.offsetInBuffer;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            if (n < (long)(this.bufferLength - this.offsetInBuffer)) {
                this.offsetInBuffer = (int)((long)this.offsetInBuffer + n);
            } else {
                int offsetInFile = this.offsetBufferInFile + this.offsetInBuffer;
                this.offsetBufferInFile = (int)((long)offsetInFile + n);
                this.offsetInBuffer = 0;
                this.bufferLength = 0;
                offsetInFile = this.offsetBufferInFile + this.offsetInBuffer;
            }
            return n;
        }
    }

    public synchronized int available() {
        return this.bufferLength - this.offsetInBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            this.markedOffset = this.offsetBufferInFile + this.offsetInBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            if (this.markedOffset < 0) {
                throw new IOException("Mark not set");
            }
            this.offsetBufferInFile = this.markedOffset;
            this.offsetInBuffer = 0;
            this.bufferLength = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markSupported() {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            return true;
        }
    }

    public int getLength() {
        return this.fileLength;
    }

    public int getPostion() {
        return this.offsetBufferInFile + this.offsetInBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillBufferFromFile(FileInfo[] path, int offsetInFile, int le) throws CardServiceException {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            if (le > this.buffer.length) {
                throw new IllegalArgumentException("length too big");
            }
            if (!Arrays.equals(this.fs.getSelectedPath(), path)) {
                for (FileInfo fileInfo : path) {
                    this.fs.selectFile(fileInfo.getFID());
                }
            }
            byte[] data = this.fs.readBinary(offsetInFile, le);
            System.arraycopy(data, 0, this.buffer, 0, data.length);
            return data.length;
        }
    }
}

