/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.APDUEvent;
import net.sf.scuba.smartcards.APDUListener;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CardService {
    protected static final int SESSION_STOPPED_STATE = 0;
    protected static final int SESSION_STARTED_STATE = 1;
    private static final Logger LOGGER = Logger.getLogger("net.sf.scuba");
    private static final Map<String, String> objectToServiceMap = new HashMap<String, String>();
    private Collection<APDUListener> apduListeners = new HashSet<APDUListener>();
    protected int state = 0;

    public static CardService getInstance(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Class<?> objectClass = object.getClass();
        String objectClassName = objectClass.getCanonicalName();
        for (Map.Entry<String, String> entry : objectToServiceMap.entrySet()) {
            String targetObjectClassName = entry.getKey();
            try {
                Class<?> targetObjectClass = Class.forName(targetObjectClassName);
                String serviceClassName = entry.getValue();
                if (!targetObjectClass.isInstance(object)) continue;
                try {
                    Class<?> cardServiceClass = Class.forName(serviceClassName);
                    return (CardService)cardServiceClass.getConstructor(targetObjectClass).newInstance(object);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.log(Level.FINEST, "Could not find class, trying next one", cnfe);
            }
        }
        throw new IllegalArgumentException("Could not find a CardService for object of class \"" + objectClassName + "\"");
    }

    public void addAPDUListener(APDUListener l) {
        if (this.apduListeners != null && l != null) {
            this.apduListeners.add(l);
        }
    }

    public void removeAPDUListener(APDUListener l) {
        if (this.apduListeners != null) {
            this.apduListeners.remove(l);
        }
    }

    public Collection<APDUListener> getAPDUListeners() {
        return Collections.unmodifiableCollection(this.apduListeners);
    }

    protected void notifyExchangedAPDU(APDUEvent event) {
        if (this.apduListeners == null || this.apduListeners.isEmpty()) {
            return;
        }
        for (APDUListener listener : this.apduListeners) {
            listener.exchangedAPDU(event);
        }
    }

    public abstract void open() throws CardServiceException;

    public abstract boolean isOpen();

    public abstract ResponseAPDU transmit(CommandAPDU var1) throws CardServiceException;

    public abstract byte[] getATR() throws CardServiceException;

    public boolean isExtendedAPDULengthSupported() {
        return false;
    }

    public abstract void close();

    public abstract boolean isConnectionLost(Exception var1);

    static {
        objectToServiceMap.put("javax.smartcardio.CardTerminal", "net.sf.scuba.smartcards.TerminalCardService");
        objectToServiceMap.put("sun.security.smartcardio.TerminalImpl", "net.sf.scuba.smartcards.TerminalCardService");
        objectToServiceMap.put("android.nfc.tech.IsoDep", "net.sf.scuba.smartcards.IsoDepCardService");
    }
}

