/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.data;

import java.io.Serializable;
import net.sf.scuba.data.Country;

public class ISOCountry
extends Country
implements Serializable {
    private static final long serialVersionUID = 7220597933847617859L;
    public static final Country AD = new ISOCountry(32, "AD", "AND", "Andorra", "Andorran");
    public static final Country AE = new ISOCountry(1924, "AE", "ARE", "United Arab Emirates", "Emirati, Emirian");
    public static final Country AF = new ISOCountry(4, "AF", "AFG", "Afghanistan", "Afghan");
    public static final Country AG = new ISOCountry(40, "AG", "ATG", "Antigua and Barbuda", "Antiguan, Barbudan");
    public static final Country AI = new ISOCountry(1632, "AI", "AIA", "Anguilla", "Anguillan");
    public static final Country AL = new ISOCountry(8, "AL", "ALB", "Albania", "Albanian");
    public static final Country AM = new ISOCountry(81, "AM", "ARM", "Armenia", "Armenian");
    public static final Country AN = new ISOCountry(1328, "AN", "ANT", "Netherlands Antilles", "Antillean");
    public static final Country AO = new ISOCountry(36, "AO", "AGO", "Angola", "Angolan");
    public static final Country AQ = new ISOCountry(16, "AQ", "ATA", "Antarctica", "Antarctic");
    public static final Country AR = new ISOCountry(50, "AR", "ARG", "Argentina", "Argentine, Argentinean, Argentinian");
    public static final Country AS = new ISOCountry(22, "AS", "ASM", "American Samoa", "American Samoan");
    public static final Country AT = new ISOCountry(64, "AT", "AUT", "Austria", "Austrian");
    public static final Country AU = new ISOCountry(54, "AU", "AUS", "Australia", "Australian");
    public static final Country AW = new ISOCountry(1331, "AW", "ABW", "Aruba", "Aruban");
    public static final Country AX = new ISOCountry(584, "AX", "ALA", "Aland Islands");
    public static final Country AZ = new ISOCountry(49, "AZ", "AZE", "Azerbaijan", "Azerbaijani, Azeri");
    public static final Country BA = new ISOCountry(112, "BA", "BIH", "Bosnia and Herzegovina", "Bosnian, Bosniak, Herzegovinian");
    public static final Country BB = new ISOCountry(82, "BB", "BRB", "Barbados", "Barbadian");
    public static final Country BD = new ISOCountry(80, "BD", "BGD", "Bangladesh", "Bangladeshi");
    public static final Country BE = new ISOCountry(86, "BE", "BEL", "Belgium", "Belgian");
    public static final Country BF = new ISOCountry(2132, "BF", "BFA", "Burkina Faso", "Burkinabe");
    public static final Country BG = new ISOCountry(256, "BG", "BGR", "Bulgaria", "Bulgarian");
    public static final Country BH = new ISOCountry(72, "BH", "BHR", "Bahrain", "Bahraini");
    public static final Country BI = new ISOCountry(264, "BI", "BDI", "Burundi", "Burundian");
    public static final Country BJ = new ISOCountry(516, "BJ", "BEN", "Benin", "Beninese");
    public static final Country BL = new ISOCountry(1618, "BL", "BLM", "Saint Barthlemy");
    public static final Country BM = new ISOCountry(96, "BM", "BMU", "Bermuda", "Bermudian, Bermudan");
    public static final Country BN = new ISOCountry(150, "BN", "BRN", "Brunei Darussalam", "Bruneian");
    public static final Country BO = new ISOCountry(104, "BO", "BOL", "Bolivia", "Bolivian");
    public static final Country BQ = new ISOCountry(1333, "BQ", "BES", "Bonaire, Sint Eustatius and Saba");
    public static final Country BR = new ISOCountry(118, "BR", "BRA", "Brazil", "Brazilian");
    public static final Country BS = new ISOCountry(68, "BS", "BHS", "Bahamas", "Bahamian");
    public static final Country BT = new ISOCountry(100, "BT", "BTN", "Bhutan", "Bhutanese");
    public static final Country BV = new ISOCountry(116, "BV", "BVT", "Bouvet Island");
    public static final Country BW = new ISOCountry(114, "BW", "BWA", "Botswana", "Botswanan");
    public static final Country BY = new ISOCountry(274, "BY", "BLR", "Belarus", "Belarusian");
    public static final Country BZ = new ISOCountry(132, "BZ", "BLZ", "Belize", "Belizean");
    public static final Country CA = new ISOCountry(292, "CA", "CAN", "Canada", "Canadian");
    public static final Country CC = new ISOCountry(358, "CC", "CCK", "Cocos (Keeling) Islands");
    public static final Country CD = new ISOCountry(384, "CD", "COD", "Congo the Democratic Republic of the", "Congolese");
    public static final Country CF = new ISOCountry(320, "CF", "CAF", "Central African Republic", "Central African");
    public static final Country CG = new ISOCountry(376, "CG", "COG", "Congo", "Congolese");
    public static final Country CH = new ISOCountry(1878, "CH", "CHE", "Switzerland", "Swiss");
    public static final Country CI = new ISOCountry(900, "CI", "CIV", "Cote d'Ivoire", "Ivorian");
    public static final Country CK = new ISOCountry(388, "CK", "COK", "Cook Islands");
    public static final Country CL = new ISOCountry(338, "CL", "CHL", "Chile", "Chilean");
    public static final Country CM = new ISOCountry(288, "CM", "CMR", "Cameroon", "Cameroonian");
    public static final Country CN = new ISOCountry(342, "CN", "CHN", "China", "Chinese");
    public static final Country CO = new ISOCountry(368, "CO", "COL", "Colombia", "Colombian");
    public static final Country CR = new ISOCountry(392, "CR", "CRI", "Costa Rica", "Costa Rican");
    public static final Country CU = new ISOCountry(402, "CU", "CUB", "Cuba", "Cuban");
    public static final Country CV = new ISOCountry(306, "CV", "CPV", "Cape Verde", "Cape Verdean");
    public static final Country CW = new ISOCountry(1329, "CW", "CUW", "Curacao");
    public static final Country CX = new ISOCountry(354, "CX", "CXR", "Christmas Island");
    public static final Country CY = new ISOCountry(406, "CY", "CYP", "Cyprus", "Cypriot");
    public static final Country CZ = new ISOCountry(515, "CZ", "CZE", "Czech Republic", "Czech");
    public static final Country DE = new ISOCountry(630, "DE", "DEU", "Germany", "German");
    public static final Country DJ = new ISOCountry(610, "DJ", "DJI", "Djibouti", "Djiboutian");
    public static final Country DK = new ISOCountry(520, "DK", "DNK", "Denmark", "Danish");
    public static final Country DM = new ISOCountry(530, "DM", "DMA", "Dominica", "Dominican");
    public static final Country DO = new ISOCountry(532, "DO", "DOM", "Dominican Republic", "Dominican");
    public static final Country DZ = new ISOCountry(18, "DZ", "DZA", "Algeria", "Algerian");
    public static final Country EC = new ISOCountry(536, "EC", "ECU", "Ecuador", "Ecuadorian");
    public static final Country EE = new ISOCountry(563, "EE", "EST", "Estonia", "Estonian");
    public static final Country EG = new ISOCountry(2072, "EG", "EGY", "Egypt", "Egyptian");
    public static final Country EH = new ISOCountry(1842, "EH", "ESH", "Western Sahara", "Sahraw, Sahrawian, Sahraouian");
    public static final Country ER = new ISOCountry(562, "ER", "ERI", "Eritrea", "Eritrean");
    public static final Country ES = new ISOCountry(1828, "ES", "ESP", "Spain", "Spanish");
    public static final Country ET = new ISOCountry(561, "ET", "ETH", "Ethiopia", "Ethiopian");
    public static final Country FI = new ISOCountry(582, "FI", "FIN", "Finland", "Finnish");
    public static final Country FJ = new ISOCountry(578, "FJ", "FJI", "Fiji", "Fijian");
    public static final Country FK = new ISOCountry(568, "FK", "FLK", "Falkland Islands (Malvinas)");
    public static final Country FM = new ISOCountry(1411, "FM", "FSM", "Micronesia Federated States of", "Micronesian");
    public static final Country FO = new ISOCountry(564, "FO", "FRO", "Faroe Islands", "Faroese");
    public static final Country FR = new ISOCountry(592, "FR", "FRA", "France", "French");
    public static final Country GA = new ISOCountry(614, "GA", "GAB", "Gabon", "Gabonese");
    public static final Country GB = new ISOCountry(2086, "GB", "GBR", "United Kingdom", "British");
    public static final Country GD = new ISOCountry(776, "GD", "GRD", "Grenada", "Grenadian");
    public static final Country GE = new ISOCountry(616, "GE", "GEO", "Georgia", "Georgian");
    public static final Country GF = new ISOCountry(596, "GF", "GUF", "French Guiana", "French Guianese");
    public static final Country GG = new ISOCountry(2097, "GG", "GGY", "Guernsey");
    public static final Country GH = new ISOCountry(648, "GH", "GHA", "Ghana", "Ghanaian");
    public static final Country GI = new ISOCountry(658, "GI", "GIB", "Gibraltar");
    public static final Country GL = new ISOCountry(772, "GL", "GRL", "Greenland", "Greenlandic");
    public static final Country GM = new ISOCountry(624, "GM", "GMB", "Gambia", "Gambian");
    public static final Country GN = new ISOCountry(804, "GN", "GIN", "Guinea", "Guinean");
    public static final Country GP = new ISOCountry(786, "GP", "GLP", "Guadeloupe");
    public static final Country GQ = new ISOCountry(550, "GQ", "GNQ", "Equatorial Guinea", "Equatorial Guinean, Equatoguinean");
    public static final Country GR = new ISOCountry(768, "GR", "GRC", "Greece", "Greek, Hellenic");
    public static final Country GS = new ISOCountry(569, "GS", "SGS", "South Georgia and the South Sandwich Islands");
    public static final Country GT = new ISOCountry(800, "GT", "GTM", "Guatemala", "Guatemalan");
    public static final Country GU = new ISOCountry(790, "GU", "GUM", "Guam", "Guamanian");
    public static final Country GW = new ISOCountry(1572, "GW", "GNB", "Guinea-Bissau", "Guinean");
    public static final Country GY = new ISOCountry(808, "GY", "GUY", "Guyana", "Guyanese");
    public static final Country HK = new ISOCountry(836, "HK", "HKG", "Hong Kong", "Hong Kong, Hongkongese");
    public static final Country HM = new ISOCountry(820, "HM", "HMD", "Heard Island and McDonald Islands");
    public static final Country HN = new ISOCountry(832, "HN", "HND", "Honduras", "Honduran");
    public static final Country HR = new ISOCountry(401, "HR", "HRV", "Croatia", "Croatian");
    public static final Country HT = new ISOCountry(818, "HT", "HTI", "Haiti", "Haitian");
    public static final Country HU = new ISOCountry(840, "HU", "HUN", "Hungary", "Hungarian");
    public static final Country ID = new ISOCountry(864, "ID", "IDN", "Indonesia", "Indonesian");
    public static final Country IE = new ISOCountry(882, "IE", "IRL", "Ireland", "Irish");
    public static final Country IL = new ISOCountry(886, "IL", "ISR", "Israel", "Israeli");
    public static final Country IM = new ISOCountry(2099, "IM", "IMN", "Isle of Man", "Manx");
    public static final Country IN = new ISOCountry(854, "IN", "IND", "India", "Indian");
    public static final Country IO = new ISOCountry(134, "IO", "IOT", "British Indian Ocean Territory");
    public static final Country IQ = new ISOCountry(872, "IQ", "IRQ", "Iraq", "Iraqi");
    public static final Country IR = new ISOCountry(868, "IR", "IRN", "Iran Islamic Republic of", "Iranian, Persian");
    public static final Country IS = new ISOCountry(850, "IS", "ISL", "Iceland", "Icelandic");
    public static final Country IT = new ISOCountry(896, "IT", "ITA", "Italy", "Italian");
    public static final Country JE = new ISOCountry(2098, "JE", "JEY", "Jersey");
    public static final Country JM = new ISOCountry(904, "JM", "JAM", "Jamaica", "Jamaican");
    public static final Country JO = new ISOCountry(1024, "JO", "JOR", "Jordan", "Jordanian");
    public static final Country JP = new ISOCountry(914, "JP", "JPN", "Japan", "Japanese");
    public static final Country KE = new ISOCountry(1028, "KE", "KEN", "Kenya", "Kenyan");
    public static final Country KG = new ISOCountry(1047, "KG", "KGZ", "Kyrgyzstan", "Kyrgyz");
    public static final Country KH = new ISOCountry(278, "KH", "KHM", "Cambodia", "Cambodian");
    public static final Country KI = new ISOCountry(662, "KI", "KIR", "Kiribati", "I-Kiribati");
    public static final Country KM = new ISOCountry(372, "KM", "COM", "Comoros", "Comorian");
    public static final Country KN = new ISOCountry(1625, "KN", "KNA", "Saint Kitts and Nevis");
    public static final Country KP = new ISOCountry(1032, "KP", "PRK", "Korea Democratic People's Republic of", "North Korean");
    public static final Country KR = new ISOCountry(1040, "KR", "KOR", "Korea Republic of", "South Korean");
    public static final Country KW = new ISOCountry(1044, "KW", "KWT", "Kuwait", "Kuwaiti");
    public static final Country KY = new ISOCountry(310, "KY", "CYM", "Cayman Islands", "Caymanian");
    public static final Country KZ = new ISOCountry(920, "KZ", "KAZ", "Kazakhstan", "Kazakh");
    public static final Country LA = new ISOCountry(1048, "LA", "LAO", "Lao People's Democratic Republic", "Lao");
    public static final Country LB = new ISOCountry(1058, "LB", "LBN", "Lebanon", "Lebanese");
    public static final Country LC = new ISOCountry(1634, "LC", "LCA", "Saint Lucia", "Saint Lucian");
    public static final Country LI = new ISOCountry(1080, "LI", "LIE", "Liechtenstein");
    public static final Country LK = new ISOCountry(324, "LK", "LKA", "Sri Lanka", "Sri Lankan");
    public static final Country LR = new ISOCountry(1072, "LR", "LBR", "Liberia", "Liberian");
    public static final Country LS = new ISOCountry(1062, "LS", "LSO", "Lesotho", "Basotho");
    public static final Country LT = new ISOCountry(1088, "LT", "LTU", "Lithuania", "Lithuanian");
    public static final Country LU = new ISOCountry(1090, "LU", "LUX", "Luxembourg", "Luxembourg, Luxembourgish");
    public static final Country LV = new ISOCountry(1064, "LV", "LVA", "Latvia", "Latvian");
    public static final Country LY = new ISOCountry(1076, "LY", "LBY", "Libyan Arab Jamahiriya", "Libyan");
    public static final Country MA = new ISOCountry(1284, "MA", "MAR", "Morocco", "Moroccan");
    public static final Country MC = new ISOCountry(1170, "MC", "MCO", "Monaco", "Monegasque, Monacan");
    public static final Country MD = new ISOCountry(1176, "MD", "MDA", "Moldova", "Moldovan");
    public static final Country ME = new ISOCountry(1177, "ME", "MNE", "Montenegro", "Montenegrin");
    public static final Country MF = new ISOCountry(1635, "MF", "MAF", "Saint Martin (French part)");
    public static final Country MG = new ISOCountry(1104, "MG", "MDG", "Madagascar", "Malagasy");
    public static final Country MH = new ISOCountry(1412, "MH", "MHL", "Marshall Islands", "Marshallese");
    public static final Country MK = new ISOCountry(2055, "MK", "MKD", "Macedonia the former Yugoslav Republic of", "Macedonian");
    public static final Country ML = new ISOCountry(1126, "ML", "MLI", "Mali", "Malian");
    public static final Country MM = new ISOCountry(260, "MM", "MMR", "Myanmar", "Burmese");
    public static final Country MN = new ISOCountry(1174, "MN", "MNG", "Mongolia", "Mongolian");
    public static final Country MO = new ISOCountry(1094, "MO", "MAC", "Macao", "Macanese, Chinese");
    public static final Country MP = new ISOCountry(1408, "MP", "MNP", "Northern Mariana Islands", "Northern Marianan");
    public static final Country MQ = new ISOCountry(1140, "MQ", "MTQ", "Martinique", "Martiniquais, Martinican");
    public static final Country MR = new ISOCountry(1144, "MR", "MRT", "Mauritania", "Mauritanian");
    public static final Country MS = new ISOCountry(1280, "MS", "MSR", "Montserrat", "Montserratian");
    public static final Country MT = new ISOCountry(1136, "MT", "MLT", "Malta", "Maltese");
    public static final Country MU = new ISOCountry(1152, "MU", "MUS", "Mauritius", "Mauritian");
    public static final Country MV = new ISOCountry(1122, "MV", "MDV", "Maldives", "Maldivian");
    public static final Country MW = new ISOCountry(1108, "MW", "MWI", "Malawi", "Malawian");
    public static final Country MX = new ISOCountry(1156, "MX", "MEX", "Mexico", "Mexican");
    public static final Country MY = new ISOCountry(1112, "MY", "MYS", "Malaysia", "Malaysian");
    public static final Country MZ = new ISOCountry(1288, "MZ", "MOZ", "Mozambique", "Mozambican");
    public static final Country NA = new ISOCountry(1302, "NA", "NAM", "Namibia", "Namibian");
    public static final Country NC = new ISOCountry(1344, "NC", "NCL", "New Caledonia", "New Caledonian");
    public static final Country NE = new ISOCountry(1378, "NE", "NER", "Niger", "Nigerien");
    public static final Country NF = new ISOCountry(1396, "NF", "NFK", "Norfolk Island");
    public static final Country NG = new ISOCountry(1382, "NG", "NGA", "Nigeria", "Nigerian");
    public static final Country NI = new ISOCountry(1368, "NI", "NIC", "Nicaragua", "Nicaraguan");
    public static final Country NL = new ISOCountry(1320, "NL", "NLD", "Netherlands", "Dutch");
    public static final Country NO = new ISOCountry(1400, "NO", "NOR", "Norway", "Norwegian");
    public static final Country NP = new ISOCountry(1316, "NP", "NPL", "Nepal", "Nepali");
    public static final Country NR = new ISOCountry(1312, "NR", "NRU", "Nauru", "Nauruan");
    public static final Country NU = new ISOCountry(1392, "NU", "NIU", "Niue", "Niuean");
    public static final Country NZ = new ISOCountry(1364, "NZ", "NZL", "New Zealand");
    public static final Country OM = new ISOCountry(1298, "OM", "OMN", "Oman", "Omani");
    public static final Country PA = new ISOCountry(1425, "PA", "PAN", "Panama", "Panamanian");
    public static final Country PE = new ISOCountry(1540, "PE", "PER", "Peru", "Peruvian");
    public static final Country PF = new ISOCountry(600, "PF", "PYF", "French Polynesia", "French Polynesian");
    public static final Country PG = new ISOCountry(1432, "PG", "PNG", "Papua New Guinea", "Papua New Guinean, Papuan");
    public static final Country PH = new ISOCountry(1544, "PH", "PHL", "Philippines", "Philippine, Filipino");
    public static final Country PK = new ISOCountry(1414, "PK", "PAK", "Pakistan", "Pakistani");
    public static final Country PL = new ISOCountry(1558, "PL", "POL", "Poland", "Polish");
    public static final Country PM = new ISOCountry(1638, "PM", "SPM", "Saint Pierre and Miquelon", "Saint Pierrais, Miquelonnais");
    public static final Country PN = new ISOCountry(1554, "PN", "PCN", "Pitcairn");
    public static final Country PR = new ISOCountry(1584, "PR", "PRI", "Puerto Rico", "Puerto Rican");
    public static final Country PS = new ISOCountry(629, "PS", "PSE", "Palestinian Territory Occupied", "Palestinian");
    public static final Country PT = new ISOCountry(1568, "PT", "PRT", "Portugal", "Portuguese");
    public static final Country PW = new ISOCountry(1413, "PW", "PLW", "Palau", "Palauan");
    public static final Country PY = new ISOCountry(1536, "PY", "PRY", "Paraguay", "Paraguayan");
    public static final Country QA = new ISOCountry(1588, "QA", "QAT", "Qatar", "Qatari");
    public static final Country RE = new ISOCountry(1592, "RE", "REU", "Reunion", "Reunionese, Reunionnais");
    public static final Country RO = new ISOCountry(1602, "RO", "ROU", "Romania", "Romanian");
    public static final Country RS = new ISOCountry(1672, "RS", "SRB", "Serbia", "Serbian");
    public static final Country RU = new ISOCountry(1603, "RU", "RUS", "Russian Federation", "Russian");
    public static final Country RW = new ISOCountry(1606, "RW", "RWA", "Rwanda", "Rwandan");
    public static final Country SA = new ISOCountry(1666, "SA", "SAU", "Saudi Arabia", "Saudi, Saudi Arabian");
    public static final Country SB = new ISOCountry(144, "SB", "SLB", "Solomon Islands", "Solomon Island");
    public static final Country SC = new ISOCountry(1680, "SC", "SYC", "Seychelles", "Seychellois");
    public static final Country SD = new ISOCountry(1846, "SD", "SDN", "Sudan", "Sudanese");
    public static final Country SE = new ISOCountry(1874, "SE", "SWE", "Sweden", "Swedish");
    public static final Country SG = new ISOCountry(1794, "SG", "SGP", "Singapore");
    public static final Country SH = new ISOCountry(1620, "SH", "SHN", "Saint Helena", "Saint Helenian");
    public static final Country SI = new ISOCountry(1797, "SI", "SVN", "Slovenia", "Slovenian, Slovene");
    public static final Country SJ = new ISOCountry(1860, "SJ", "SJM", "Svalbard and Jan Mayen");
    public static final Country SK = new ISOCountry(1795, "SK", "SVK", "Slovakia", "Slovak");
    public static final Country SL = new ISOCountry(1684, "SL", "SLE", "Sierra Leone", "Sierra Leonean");
    public static final Country SM = new ISOCountry(1652, "SM", "SMR", "San Marino", "Sammarinese");
    public static final Country SN = new ISOCountry(1670, "SN", "SEN", "Senegal", "Senegalese");
    public static final Country SO = new ISOCountry(1798, "SO", "SOM", "Somalia", "Somali, Somalian");
    public static final Country SR = new ISOCountry(1856, "SR", "SUR", "Suriname", "Surinamese");
    public static final Country SS = new ISOCountry(1832, "SS", "SSD", "South Sudan");
    public static final Country ST = new ISOCountry(1656, "ST", "STP", "Sao Tome and Principe", "Sao Tomean");
    public static final Country SV = new ISOCountry(546, "SV", "SLV", "El Salvador", "Salvadoran");
    public static final Country SX = new ISOCountry(1332, "SX", "SXM", "Sint Maarten (Dutch part)");
    public static final Country SY = new ISOCountry(1888, "SY", "SYR", "Syrian Arab Republic", "Syrian");
    public static final Country SZ = new ISOCountry(1864, "SZ", "SWZ", "Swaziland", "Swazi");
    public static final Country TC = new ISOCountry(1942, "TC", "TCA", "Turks and Caicos Islands");
    public static final Country TD = new ISOCountry(328, "TD", "TCD", "Chad", "Chadian");
    public static final Country TF = new ISOCountry(608, "TF", "ATF", "French Southern Territories");
    public static final Country TG = new ISOCountry(1896, "TG", "TGO", "Togo", "Togolese");
    public static final Country TH = new ISOCountry(1892, "TH", "THA", "Thailand", "Thai");
    public static final Country TJ = new ISOCountry(1890, "TJ", "TJK", "Tajikistan", "Tajikistani");
    public static final Country TK = new ISOCountry(1906, "TK", "TKL", "Tokelau");
    public static final Country TL = new ISOCountry(1574, "TL", "TLS", "Timor-Leste", "Timorese");
    public static final Country TM = new ISOCountry(1941, "TM", "TKM", "Turkmenistan", "Turkmen");
    public static final Country TN = new ISOCountry(1928, "TN", "TUN", "Tunisia", "Tunisian");
    public static final Country TO = new ISOCountry(1910, "TO", "TON", "Tonga", "Tongan");
    public static final Country TR = new ISOCountry(1938, "TR", "TUR", "Turkey", "Turkish");
    public static final Country TT = new ISOCountry(1920, "TT", "TTO", "Trinidad and Tobago", "Trinidadian, Tobagonian");
    public static final Country TV = new ISOCountry(1944, "TV", "TUV", "Tuvalu", "Tuvaluan");
    public static final Country TW = new ISOCountry(344, "TW", "TWN", "Taiwan Province of China", "Taiwanese");
    public static final Country TZ = new ISOCountry(2100, "TZ", "TZA", "Tanzania United Republic of", "Tanzanian");
    public static final Country UA = new ISOCountry(2052, "UA", "UKR", "Ukraine", "Ukrainian");
    public static final Country UG = new ISOCountry(2048, "UG", "UGA", "Uganda", "Ugandan");
    public static final Country UM = new ISOCountry(1409, "UM", "UMI", "United States Minor Outlying Islands");
    public static final Country US = new ISOCountry(2112, "US", "USA", "United States", "American");
    public static final Country UY = new ISOCountry(2136, "UY", "URY", "Uruguay", "Uruguayan");
    public static final Country UZ = new ISOCountry(2144, "UZ", "UZB", "Uzbekistan", "Uzbekistani, Uzbek");
    public static final Country VA = new ISOCountry(822, "VA", "VAT", "Holy See (Vatican City State)");
    public static final Country VC = new ISOCountry(1648, "VC", "VCT", "Saint Vincent and the Grenadines", "Saint Vincentian");
    public static final Country VE = new ISOCountry(2146, "VE", "VEN", "Venezuela", "Venezuelan");
    public static final Country VG = new ISOCountry(146, "VG", "VGB", "Virgin Islands British", "Virgin Island");
    public static final Country VI = new ISOCountry(2128, "VI", "VIR", "Virgin Islands U.S.", "Virgin Island");
    public static final Country VN = new ISOCountry(1796, "VN", "VNM", "Viet Nam", "Vietnamese");
    public static final Country VU = new ISOCountry(1352, "VU", "VUT", "Vanuatu", "Ni-Vanuatu, Vanuatuan");
    public static final Country WF = new ISOCountry(2166, "WF", "WLF", "Wallis and Futuna", "Wallisian, Futunan");
    public static final Country WS = new ISOCountry(2178, "WS", "WSM", "Samoa", "Samoan");
    public static final Country YE = new ISOCountry(2183, "YE", "YEM", "Yemen", "Yemeni");
    public static final Country YT = new ISOCountry(373, "YT", "MYT", "Mayotte", "Mahoran");
    public static final Country ZA = new ISOCountry(1808, "ZA", "ZAF", "South Africa", "South African");
    public static final Country ZM = new ISOCountry(2196, "ZM", "ZMB", "Zambia", "Zambian");
    public static final Country ZW = new ISOCountry(1814, "ZW", "ZWE", "Zimbabwe", "Zimbabwean");
    private static final Country[] VALUES = new Country[]{AW, AF, AO, AI, AX, AL, AD, AN, AE, AR, AM, AS, AQ, TF, AG, AU, AT, AZ, BI, BE, BJ, BF, BD, BG, BH, BS, BA, BL, BY, BZ, BM, BO, BR, BB, BN, BT, BV, BW, CF, CA, CC, CH, CL, CN, CI, CM, CD, CG, CK, CO, KM, CV, CR, CU, CX, KY, CY, CZ, DE, DJ, DM, DK, DO, DZ, EC, EG, ER, EH, ES, EE, ET, FI, FJ, FK, FR, FO, FM, GA, GB, GE, GG, GH, GI, GN, GP, GM, GW, GQ, GR, GD, GL, GT, GF, GU, GY, HK, HM, HN, HR, HT, HU, ID, IM, IN, IO, IE, IR, IQ, IS, IL, IT, JM, JE, JO, JP, KZ, KE, KG, KH, KI, KN, KR, KW, LA, LB, LR, LY, LC, LI, LK, LS, LT, LU, LV, MO, MF, MA, MC, MD, MG, MV, MX, MH, MK, ML, MT, MM, ME, MN, MP, MZ, MR, MS, MQ, MU, MW, MY, YT, NA, NC, NE, NF, NG, NI, NU, NL, NO, NP, NR, NZ, OM, PK, PA, PN, PE, PH, PW, PG, PL, PR, KP, PT, PY, PS, PF, QA, RE, RO, RU, RW, SA, SD, SN, SG, GS, SH, SJ, SB, SL, SV, SM, SO, PM, RS, ST, SR, SK, SI, SE, SZ, SC, SY, TC, TD, TG, TH, TJ, TK, TM, TL, TO, TT, TN, TR, TV, TW, TZ, UG, UA, UM, UY, US, UZ, VA, VC, VE, VG, VI, VN, VU, WF, WS, YE, ZA, ZM, ZW};
    private int code;
    private String alpha2Code;
    private String alpha3Code;
    private String name;
    private String nationality;

    private ISOCountry(int code, String alpha2Code, String alpha3Code, String name) {
        this(code, alpha2Code, alpha3Code, name, name);
    }

    private ISOCountry(int code, String alpha2Code, String alpha3Code, String name, String nationality) {
        this.code = code;
        this.alpha2Code = alpha2Code;
        this.alpha3Code = alpha3Code;
        this.name = name;
        this.nationality = nationality;
    }

    public static Country[] values() {
        return VALUES;
    }

    @Override
    public int valueOf() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNationality() {
        return this.nationality;
    }

    public String toString() {
        return this.alpha2Code;
    }

    @Override
    public String toAlpha2Code() {
        return this.alpha2Code;
    }

    @Override
    public String toAlpha3Code() {
        return this.alpha3Code;
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ISOCountry other = (ISOCountry)obj;
        return other.code == this.code;
    }

    public int compareTo(Country o) {
        return this.toAlpha2Code().compareTo(o.toAlpha2Code());
    }
}

