/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.FileSystemStructured;
import net.sf.scuba.smartcards.ISOFileInfo;
import net.sf.scuba.smartcards.ResponseAPDU;

public abstract class AbstractFileSystemStructured
implements FileSystemStructured {
    public static final short MF_ID = 16128;
    private CardService service = null;
    private short selectedFID = 0;
    private int length = -1;
    private int p2 = 0;
    private int selectLe = 256;
    private ISOFileInfo fileInfo = null;

    public AbstractFileSystemStructured(CardService service) {
        this.service = service;
    }

    public AbstractFileSystemStructured(CardService service, boolean fileInfo) {
        this.service = service;
        this.p2 = fileInfo ? 0 : 12;
        this.selectLe = fileInfo ? 256 : 0;
    }

    public int getFileLength() throws CardServiceException {
        return this.length;
    }

    public short getSelectedFID() {
        return this.selectedFID;
    }

    @Override
    public abstract byte[] readBinary(int var1, int var2);

    private void selectFile(byte[] data, int p1) throws CardServiceException {
        CommandAPDU command = this.createSelectFileAPDU(p1, this.p2, data, this.selectLe);
        ResponseAPDU response = this.service.transmit(command);
        int respSW = response.getSW();
        byte[] respData = response.getData();
        if (respSW != -28672) {
            throw new CardServiceException("File could not be selected.", respSW);
        }
        this.fileInfo = new ISOFileInfo(respData);
        if (this.fileInfo.fid != -1) {
            this.selectedFID = this.fileInfo.fid;
        }
        if (this.fileInfo.fileLength != -1) {
            this.length = this.fileInfo.fileLength;
        }
    }

    private void selectFile(short fid, int p1) throws CardServiceException {
        byte[] byArray;
        if (fid == 0) {
            byArray = new byte[]{};
        } else {
            byte[] byArray2 = new byte[2];
            byArray2[0] = (byte)(fid >> 8 & 0xFF);
            byArray = byArray2;
            byArray2[1] = (byte)(fid & 0xFF);
        }
        byte[] fidbytes = byArray;
        this.selectFile(fidbytes, p1);
    }

    @Override
    public void selectFile(short fid) throws CardServiceException {
        this.selectFile(fid, 0);
    }

    public void selectMF() throws CardServiceException {
        this.selectFile((short)0, 0);
    }

    public void selectParent() throws CardServiceException {
        this.selectFile((short)0, 3);
    }

    public void selectEFRelative(short fid) throws CardServiceException {
        this.selectFile(fid, 2);
    }

    public void selectDFRelative(short fid) throws CardServiceException {
        this.selectFile(fid, 1);
    }

    public void selectAID(byte[] aid) throws CardServiceException {
        this.selectFile(aid, 4);
    }

    public void selectPath(byte[] path) throws CardServiceException {
        this.selectFile(path, 8);
    }

    public void selectPathRelative(byte[] path) throws CardServiceException {
        this.selectFile(path, 9);
    }

    private CommandAPDU createSelectFileAPDU(int p1, int p2, byte[] data, int le) {
        if (le == 0) {
            return new CommandAPDU(0, -92, p1, p2, data);
        }
        return new CommandAPDU(0, -92, p1, p2, data, le);
    }
}

