/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.scuba.tlv.TLVOutputState;
import net.sf.scuba.tlv.TLVUtil;

public class TLVOutputStream
extends OutputStream {
    private DataOutputStream outputStream;
    private TLVOutputState state;

    public TLVOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        this.state = new TLVOutputState();
    }

    public void writeTag(int tag) throws IOException {
        byte[] tagAsBytes = TLVUtil.getTagAsBytes(tag);
        if (this.state.canBeWritten()) {
            this.outputStream.write(tagAsBytes);
        }
        this.state.setTagProcessed(tag);
    }

    public void writeLength(int length) throws IOException {
        byte[] lengthAsBytes = TLVUtil.getLengthAsBytes(length);
        this.state.setLengthProcessed(length);
        if (this.state.canBeWritten()) {
            this.outputStream.write(lengthAsBytes);
        }
    }

    public void writeValue(byte[] value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Cannot write null.");
        }
        if (this.state.isAtStartOfTag()) {
            throw new IllegalStateException("Cannot write value bytes yet. Need to write a tag first.");
        }
        if (this.state.isAtStartOfLength()) {
            this.writeLength(value.length);
            this.write(value);
        } else {
            this.write(value);
            this.state.updatePreviousLength(value.length);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (this.state.isAtStartOfTag()) {
            throw new IllegalStateException("Cannot write value bytes yet. Need to write a tag first.");
        }
        if (this.state.isAtStartOfLength()) {
            this.state.setDummyLengthProcessed();
        }
        this.state.updateValueBytesProcessed(bytes, offset, length);
        if (this.state.canBeWritten()) {
            this.outputStream.write(bytes, offset, length);
        }
    }

    public void writeValueEnd() throws IOException {
        if (this.state.isAtStartOfLength()) {
            throw new IllegalStateException("Not processing value yet.");
        }
        if (this.state.isAtStartOfTag() && !this.state.isDummyLengthSet()) {
            return;
        }
        byte[] bufferedValueBytes = this.state.getValue();
        int length = bufferedValueBytes.length;
        this.state.updatePreviousLength(length);
        if (this.state.canBeWritten()) {
            byte[] lengthAsBytes = TLVUtil.getLengthAsBytes(length);
            this.outputStream.write(lengthAsBytes);
            this.outputStream.write(bufferedValueBytes);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.state.canBeWritten()) {
            throw new IllegalStateException("Cannot close stream yet, illegal TLV state.");
        }
        this.outputStream.close();
    }
}

