/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.FileSystemStructured;
import net.sf.scuba.smartcards.ISOFileInfo;
import net.sf.scuba.smartcards.ResponseAPDU;

public abstract class AbstractFileSystemStructured
implements FileSystemStructured {
    public static short MF_ID = (short)16128;
    private CardService service = null;
    private short selectedFID = 0;
    private int length = -1;
    private int p2 = 0;
    private int selectLe = 256;
    private ISOFileInfo fileInfo = null;

    public AbstractFileSystemStructured(CardService cardService) {
        this.service = cardService;
    }

    public AbstractFileSystemStructured(CardService cardService, boolean bl) {
        this.service = cardService;
        this.p2 = bl ? 0 : 12;
        this.selectLe = bl ? 256 : 0;
    }

    public int getFileLength() throws CardServiceException {
        return this.length;
    }

    public short getSelectedFID() {
        return this.selectedFID;
    }

    @Override
    public abstract byte[] readBinary(int var1, int var2);

    private void selectFile(byte[] byArray, int n) throws CardServiceException {
        CommandAPDU commandAPDU = this.createSelectFileAPDU(n, this.p2, byArray, this.selectLe);
        ResponseAPDU responseAPDU = this.service.transmit(commandAPDU);
        int n2 = responseAPDU.getSW();
        byte[] byArray2 = responseAPDU.getData();
        if (n2 != -28672) {
            throw new CardServiceException("File could not be selected.", n2);
        }
        this.fileInfo = new ISOFileInfo(byArray2);
        if (this.fileInfo.fid != -1) {
            this.selectedFID = this.fileInfo.fid;
        }
        if (this.fileInfo.fileLength != -1) {
            this.length = this.fileInfo.fileLength;
        }
    }

    private void selectFile(short s, int n) throws CardServiceException {
        byte[] byArray;
        if (s == 0) {
            byArray = new byte[]{};
        } else {
            byte[] byArray2 = new byte[2];
            byArray2[0] = (byte)(s >> 8 & 0xFF);
            byArray = byArray2;
            byArray2[1] = (byte)(s & 0xFF);
        }
        byte[] byArray3 = byArray;
        this.selectFile(byArray3, n);
    }

    @Override
    public void selectFile(short s) throws CardServiceException {
        this.selectFile(s, 0);
    }

    public void selectMF() throws CardServiceException {
        this.selectFile((short)0, 0);
    }

    public void selectParent() throws CardServiceException {
        this.selectFile((short)0, 3);
    }

    public void selectEFRelative(short s) throws CardServiceException {
        this.selectFile(s, 2);
    }

    public void selectDFRelative(short s) throws CardServiceException {
        this.selectFile(s, 1);
    }

    public void selectAID(byte[] byArray) throws CardServiceException {
        this.selectFile(byArray, 4);
    }

    public void selectPath(byte[] byArray) throws CardServiceException {
        this.selectFile(byArray, 8);
    }

    public void selectPathRelative(byte[] byArray) throws CardServiceException {
        this.selectFile(byArray, 9);
    }

    private CommandAPDU createSelectFileAPDU(int n, int n2, byte[] byArray, int n3) {
        if (n3 == 0) {
            return new CommandAPDU(0, -92, n, n2, byArray);
        }
        return new CommandAPDU(0, -92, n, n2, byArray, n3);
    }
}

