/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;

public final class ResponseAPDU
implements Serializable {
    private static final long serialVersionUID = 6962744978375594225L;
    private byte[] apdu;

    public ResponseAPDU(byte[] byArray) {
        byArray = (byte[])byArray.clone();
        ResponseAPDU.check(byArray);
        this.apdu = byArray;
    }

    private static void check(byte[] byArray) {
        if (byArray.length < 2) {
            throw new IllegalArgumentException("apdu must be at least 2 bytes long");
        }
    }

    public int getNr() {
        return this.apdu.length - 2;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.apdu.length - 2];
        System.arraycopy(this.apdu, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public int getSW1() {
        return this.apdu[this.apdu.length - 2] & 0xFF;
    }

    public int getSW2() {
        return this.apdu[this.apdu.length - 1] & 0xFF;
    }

    public int getSW() {
        return this.getSW1() << 8 | this.getSW2();
    }

    public byte[] getBytes() {
        return (byte[])this.apdu.clone();
    }

    public String toString() {
        return "ResponseAPDU: " + this.apdu.length + " bytes, SW=" + Integer.toHexString(this.getSW());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResponseAPDU)) {
            return false;
        }
        ResponseAPDU responseAPDU = (ResponseAPDU)object;
        return Arrays.equals(this.apdu, responseAPDU.apdu);
    }

    public int hashCode() {
        return Arrays.hashCode(this.apdu);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.apdu = (byte[])objectInputStream.readUnshared();
        ResponseAPDU.check(this.apdu);
    }
}

