/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Stack;
import net.sf.scuba.tlv.TLVUtil;
import net.sf.scuba.util.Hex;

class TLVOutputState
implements Cloneable {
    private Stack<TLVStruct> state;
    private boolean isAtStartOfTag;
    private boolean isAtStartOfLength;
    private boolean isReadingValue;

    public TLVOutputState() {
        this.state = new Stack();
        this.isAtStartOfTag = true;
        this.isAtStartOfLength = false;
        this.isReadingValue = false;
    }

    private TLVOutputState(Stack<TLVStruct> stack, boolean bl, boolean bl2, boolean bl3) {
        this.state = stack;
        this.isAtStartOfTag = bl;
        this.isAtStartOfLength = bl2;
        this.isReadingValue = bl3;
    }

    public boolean isAtStartOfTag() {
        return this.isAtStartOfTag;
    }

    public boolean isAtStartOfLength() {
        return this.isAtStartOfLength;
    }

    public boolean isProcessingValue() {
        return this.isReadingValue;
    }

    public int getTag() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Tag not yet read.");
        }
        TLVStruct tLVStruct = this.state.peek();
        return tLVStruct.getTag();
    }

    public int getLength() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Length not yet known.");
        }
        TLVStruct tLVStruct = this.state.peek();
        int n = tLVStruct.getLength();
        if (n < 0) {
            throw new IllegalStateException("Length not yet knwon.");
        }
        return n;
    }

    public int getValueBytesProcessed() {
        TLVStruct tLVStruct = this.state.peek();
        return tLVStruct.getValueBytesProcessed();
    }

    public int getValueBytesLeft() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Length of value is unknown.");
        }
        TLVStruct tLVStruct = this.state.peek();
        int n = tLVStruct.getLength();
        int n2 = tLVStruct.getValueBytesProcessed();
        return n - n2;
    }

    public void setTagProcessed(int n) {
        TLVStruct tLVStruct = new TLVStruct(n);
        if (!this.state.isEmpty()) {
            TLVStruct tLVStruct2 = this.state.peek();
            byte[] byArray = TLVUtil.getTagAsBytes(n);
            tLVStruct2.write(byArray, 0, byArray.length);
        }
        this.state.push(tLVStruct);
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = true;
        this.isReadingValue = false;
    }

    public void setDummyLengthProcessed() {
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = false;
        this.isReadingValue = true;
    }

    public boolean isDummyLengthSet() {
        if (this.state.isEmpty()) {
            return false;
        }
        return !this.state.peek().isLengthSet();
    }

    public void setLengthProcessed(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Cannot set negative length (length = " + n + ").");
        }
        TLVStruct tLVStruct = this.state.pop();
        if (!this.state.isEmpty()) {
            TLVStruct tLVStruct2 = this.state.peek();
            byte[] byArray = TLVUtil.getLengthAsBytes(n);
            tLVStruct2.write(byArray, 0, byArray.length);
        }
        tLVStruct.setLength(n);
        this.state.push(tLVStruct);
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = false;
        this.isReadingValue = true;
    }

    public void updatePreviousLength(int n) {
        if (this.state.isEmpty()) {
            return;
        }
        TLVStruct tLVStruct = this.state.peek();
        if (tLVStruct.isLengthSet && tLVStruct.getLength() == n) {
            return;
        }
        tLVStruct.setLength(n);
        if (tLVStruct.getValueBytesProcessed() == tLVStruct.getLength()) {
            this.state.pop();
            byte[] byArray = TLVUtil.getLengthAsBytes(n);
            byte[] byArray2 = tLVStruct.getValue();
            this.updateValueBytesProcessed(byArray, 0, byArray.length);
            this.updateValueBytesProcessed(byArray2, 0, byArray2.length);
            this.isAtStartOfTag = true;
            this.isAtStartOfLength = false;
            this.isReadingValue = false;
        }
    }

    public void updateValueBytesProcessed(byte[] byArray, int n, int n2) {
        if (this.state.isEmpty()) {
            return;
        }
        TLVStruct tLVStruct = this.state.peek();
        int n3 = tLVStruct.getLength() - tLVStruct.getValueBytesProcessed();
        if (n2 > n3) {
            throw new IllegalArgumentException("Cannot process " + n2 + " bytes! Only " + n3 + " bytes left in this TLV object " + tLVStruct);
        }
        tLVStruct.write(byArray, n, n2);
        if (tLVStruct.getValueBytesProcessed() == tLVStruct.getLength()) {
            this.state.pop();
            this.updateValueBytesProcessed(tLVStruct.getValue(), 0, tLVStruct.getLength());
            this.isAtStartOfTag = true;
            this.isAtStartOfLength = false;
            this.isReadingValue = false;
        } else {
            this.isAtStartOfTag = false;
            this.isAtStartOfLength = false;
            this.isReadingValue = true;
        }
    }

    public byte[] getValue() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Cannot get value yet.");
        }
        return this.state.peek().getValue();
    }

    public Object clone() {
        return new TLVOutputState((Stack)this.state.clone(), this.isAtStartOfTag, this.isAtStartOfLength, this.isReadingValue);
    }

    public String toString() {
        return this.state.toString();
    }

    public boolean canBeWritten() {
        for (TLVStruct tLVStruct : this.state) {
            if (tLVStruct.isLengthSet()) continue;
            return false;
        }
        return true;
    }

    private class TLVStruct
    implements Cloneable {
        private int tag;
        private int length;
        private boolean isLengthSet;
        private ByteArrayOutputStream value;

        public TLVStruct(int n) {
            this.tag = n;
            this.length = Integer.MAX_VALUE;
            this.isLengthSet = false;
            this.value = new ByteArrayOutputStream();
        }

        public void setLength(int n) {
            this.length = n;
            this.isLengthSet = true;
        }

        public int getTag() {
            return this.tag;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isLengthSet() {
            return this.isLengthSet;
        }

        public int getValueBytesProcessed() {
            return this.value.size();
        }

        public byte[] getValue() {
            return this.value.toByteArray();
        }

        public void write(byte[] byArray, int n, int n2) {
            this.value.write(byArray, n, n2);
        }

        public Object clone() {
            TLVStruct tLVStruct = new TLVStruct(this.tag);
            tLVStruct.length = this.length;
            tLVStruct.value = new ByteArrayOutputStream();
            try {
                tLVStruct.value.write(this.value.toByteArray());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return tLVStruct;
        }

        public String toString() {
            byte[] byArray = this.value.toByteArray();
            return "[TLVStruct " + Integer.toHexString(this.tag) + ", " + (this.isLengthSet ? Integer.valueOf(this.length) : "UNDEFINED") + ", " + Hex.bytesToHexString(byArray) + "(" + byArray.length + ") ]";
        }
    }
}

