/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.util.Stack;

class TLVInputState
implements Cloneable {
    private Stack<TLStruct> state;
    private boolean isAtStartOfTag;
    private boolean isAtStartOfLength;
    private boolean isReadingValue;

    public TLVInputState() {
        this.state = new Stack();
        this.isAtStartOfTag = true;
        this.isAtStartOfLength = false;
        this.isReadingValue = false;
    }

    private TLVInputState(Stack<TLStruct> stack, boolean bl, boolean bl2, boolean bl3) {
        this.state = stack;
        this.isAtStartOfTag = bl;
        this.isAtStartOfLength = bl2;
        this.isReadingValue = bl3;
    }

    public boolean isAtStartOfTag() {
        return this.isAtStartOfTag;
    }

    public boolean isAtStartOfLength() {
        return this.isAtStartOfLength;
    }

    public boolean isProcessingValue() {
        return this.isReadingValue;
    }

    public int getTag() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Tag not yet read.");
        }
        TLStruct tLStruct = this.state.peek();
        return tLStruct.getTag();
    }

    public int getLength() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Length not yet known.");
        }
        TLStruct tLStruct = this.state.peek();
        int n = tLStruct.getLength();
        return n;
    }

    public int getValueBytesProcessed() {
        TLStruct tLStruct = this.state.peek();
        return tLStruct.getValueBytesProcessed();
    }

    public int getValueBytesLeft() {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Length of value is unknown.");
        }
        TLStruct tLStruct = this.state.peek();
        int n = tLStruct.getLength();
        int n2 = tLStruct.getValueBytesProcessed();
        return n - n2;
    }

    public void setTagProcessed(int n, int n2) {
        TLStruct tLStruct = new TLStruct(n);
        if (!this.state.isEmpty()) {
            TLStruct tLStruct2 = this.state.peek();
            tLStruct2.updateValueBytesProcessed(n2);
        }
        this.state.push(tLStruct);
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = true;
        this.isReadingValue = false;
    }

    public void setDummyLengthProcessed() {
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = false;
        this.isReadingValue = true;
    }

    public void setLengthProcessed(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Cannot set negative length (length = " + n + ", 0x" + Integer.toHexString(n) + " for tag " + Integer.toHexString(this.getTag()) + ").");
        }
        TLStruct tLStruct = this.state.pop();
        if (!this.state.isEmpty()) {
            TLStruct tLStruct2 = this.state.peek();
            tLStruct2.updateValueBytesProcessed(n2);
        }
        tLStruct.setLength(n);
        this.state.push(tLStruct);
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = false;
        this.isReadingValue = true;
    }

    public void updateValueBytesProcessed(int n) {
        if (this.state.isEmpty()) {
            return;
        }
        TLStruct tLStruct = this.state.peek();
        int n2 = tLStruct.getLength() - tLStruct.getValueBytesProcessed();
        if (n > n2) {
            throw new IllegalArgumentException("Cannot process " + n + " bytes! Only " + n2 + " bytes left in this TLV object " + tLStruct);
        }
        tLStruct.updateValueBytesProcessed(n);
        int n3 = tLStruct.getLength();
        if (tLStruct.getValueBytesProcessed() == n3) {
            this.state.pop();
            this.updateValueBytesProcessed(n3);
            this.isAtStartOfTag = true;
            this.isAtStartOfLength = false;
            this.isReadingValue = false;
        } else {
            this.isAtStartOfTag = false;
            this.isAtStartOfLength = false;
            this.isReadingValue = true;
        }
    }

    public Object clone() {
        Stack<TLStruct> stack = new Stack<TLStruct>();
        for (int i = 0; i < this.state.size(); ++i) {
            TLStruct tLStruct = (TLStruct)this.state.get(i);
            stack.add((TLStruct)tLStruct.clone());
        }
        return new TLVInputState(stack, this.isAtStartOfTag, this.isAtStartOfLength, this.isReadingValue);
    }

    public String toString() {
        return this.state.toString();
    }

    private class TLStruct
    implements Cloneable {
        private int tag;
        private int length;
        private int valueBytesRead;

        public TLStruct(int n) {
            this.tag = n;
            this.length = Integer.MAX_VALUE;
            this.valueBytesRead = 0;
        }

        public void setLength(int n) {
            this.length = n;
        }

        public int getTag() {
            return this.tag;
        }

        public int getLength() {
            return this.length;
        }

        public int getValueBytesProcessed() {
            return this.valueBytesRead;
        }

        public void updateValueBytesProcessed(int n) {
            this.valueBytesRead += n;
        }

        public Object clone() {
            TLStruct tLStruct = new TLStruct(this.tag);
            tLStruct.length = this.length;
            tLStruct.valueBytesRead = this.valueBytesRead;
            return tLStruct;
        }

        public String toString() {
            return "[TLStruct " + Integer.toHexString(this.tag) + ", " + this.length + ", " + this.valueBytesRead + "]";
        }
    }
}

