/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.FileInfo;
import net.sf.scuba.smartcards.FileSystemStructured;

public class CardFileInputStream
extends InputStream {
    private FileInfo[] path;
    private final byte[] buffer;
    private int bufferLength;
    private int offsetBufferInFile;
    private int offsetInBuffer;
    private int markedOffset;
    private int fileLength;
    private FileSystemStructured fs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardFileInputStream(int n, FileSystemStructured fileSystemStructured) throws CardServiceException {
        this.fs = fileSystemStructured;
        FileSystemStructured fileSystemStructured2 = fileSystemStructured;
        synchronized (fileSystemStructured2) {
            Object[] objectArray = fileSystemStructured.getSelectedPath();
            if (objectArray == null || objectArray.length < 1) {
                throw new CardServiceException("No valid file selected, path = " + Arrays.toString(objectArray));
            }
            this.path = new FileInfo[objectArray.length];
            System.arraycopy(objectArray, 0, this.path, 0, objectArray.length);
            this.fileLength = ((FileInfo)objectArray[objectArray.length - 1]).getFileLength();
            this.buffer = new byte[n];
            this.bufferLength = 0;
            this.offsetBufferInFile = 0;
            this.offsetInBuffer = 0;
            this.markedOffset = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            int n;
            try {
                if (!Arrays.equals(this.path, this.fs.getSelectedPath())) {
                    for (FileInfo fileInfo : this.path) {
                        this.fs.selectFile(fileInfo.getFID());
                    }
                }
            }
            catch (CardServiceException cardServiceException) {
                cardServiceException.printStackTrace();
                throw new IOException(cardServiceException.getMessage());
            }
            int n2 = this.offsetBufferInFile + this.offsetInBuffer;
            if (n2 >= this.fileLength) {
                return -1;
            }
            if (this.offsetInBuffer >= this.bufferLength) {
                n = Math.min(this.buffer.length, this.fileLength - n2);
                try {
                    int n3 = this.offsetBufferInFile + this.bufferLength;
                    int n4 = 0;
                    int n5 = this.fillBufferFromFile(this.path, n3, n);
                    this.offsetBufferInFile = n3;
                    this.offsetInBuffer = n4;
                    this.bufferLength = n5;
                }
                catch (CardServiceException cardServiceException) {
                    throw new IOException(cardServiceException.toString());
                }
                catch (Exception exception) {
                    throw new IOException("DEBUG: Unexpected Exception: " + exception.getMessage());
                }
            }
            n = this.buffer[this.offsetInBuffer] & 0xFF;
            ++this.offsetInBuffer;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            if (l < (long)(this.bufferLength - this.offsetInBuffer)) {
                this.offsetInBuffer = (int)((long)this.offsetInBuffer + l);
            } else {
                int n = this.offsetBufferInFile + this.offsetInBuffer;
                this.offsetBufferInFile = (int)((long)n + l);
                this.offsetInBuffer = 0;
                this.bufferLength = 0;
                n = this.offsetBufferInFile + this.offsetInBuffer;
            }
            return l;
        }
    }

    @Override
    public synchronized int available() {
        return this.bufferLength - this.offsetInBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            this.markedOffset = this.offsetBufferInFile + this.offsetInBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            if (this.markedOffset < 0) {
                throw new IOException("Mark not set");
            }
            this.offsetBufferInFile = this.markedOffset;
            this.offsetInBuffer = 0;
            this.bufferLength = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            return true;
        }
    }

    public int getLength() {
        return this.fileLength;
    }

    public int getPostion() {
        return this.offsetBufferInFile + this.offsetInBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillBufferFromFile(FileInfo[] fileInfoArray, int n, int n2) throws CardServiceException {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            if (n2 > this.buffer.length) {
                throw new IllegalArgumentException("length too big");
            }
            if (!Arrays.equals(this.fs.getSelectedPath(), fileInfoArray)) {
                for (FileInfo fileInfo : fileInfoArray) {
                    this.fs.selectFile(fileInfo.getFID());
                }
            }
            byte[] byArray = this.fs.readBinary(n, n2);
            System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
            return byArray.length;
        }
    }
}

