/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sf.scuba.smartcards.APDUEvent;
import net.sf.scuba.smartcards.APDUListener;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;

public abstract class CardService
implements Serializable {
    private static final long serialVersionUID = 5618527358158494957L;
    protected static final int SESSION_STOPPED_STATE = 0;
    protected static final int SESSION_STARTED_STATE = 1;
    private static final Map<String, String> objectToServiceMap = new HashMap<String, String>();
    private Collection<APDUListener> apduListeners = new HashSet<APDUListener>();
    protected int state = 0;

    public static CardService getInstance(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = object.getClass();
        String string = clazz.getCanonicalName();
        for (Map.Entry<String, String> entry : objectToServiceMap.entrySet()) {
            String string2 = entry.getKey();
            try {
                Class<?> clazz2 = Class.forName(string2);
                String string3 = entry.getValue();
                if (!clazz2.isInstance(object)) continue;
                try {
                    Class<?> clazz3 = Class.forName(string3);
                    return (CardService)clazz3.getConstructor(clazz2).newInstance(object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new IllegalArgumentException("Could not find a CardService for object of class \"" + string + "\"");
    }

    public void addAPDUListener(APDUListener aPDUListener) {
        if (this.apduListeners != null) {
            this.apduListeners.add(aPDUListener);
        }
    }

    public void removeAPDUListener(APDUListener aPDUListener) {
        if (this.apduListeners != null) {
            this.apduListeners.remove(aPDUListener);
        }
    }

    protected void notifyExchangedAPDU(int n, CommandAPDU commandAPDU, ResponseAPDU responseAPDU) {
        if (this.apduListeners == null || this.apduListeners.size() < 1) {
            return;
        }
        APDUEvent aPDUEvent = new APDUEvent(this, "RAW", n, commandAPDU, responseAPDU);
        for (APDUListener aPDUListener : this.apduListeners) {
            aPDUListener.exchangedAPDU(aPDUEvent);
        }
    }

    public abstract void open() throws CardServiceException;

    public abstract boolean isOpen();

    public abstract ResponseAPDU transmit(CommandAPDU var1) throws CardServiceException;

    public abstract byte[] getATR() throws CardServiceException;

    public boolean isExtendedAPDULengthSupported() {
        return false;
    }

    public abstract void close();

    static {
        objectToServiceMap.put("javax.smartcardio.CardTerminal", "net.sf.scuba.smartcards.TerminalCardService");
        objectToServiceMap.put("sun.security.smartcardio.TerminalImpl", "net.sf.scuba.smartcards.TerminalCardService");
        objectToServiceMap.put("android.nfc.tech.IsoDep", "net.sf.scuba.smartcards.IsoDepCardService");
    }
}

