/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.io.ByteArrayOutputStream;
import net.sf.scuba.tlv.ASN1Constants;

public class TLVUtil
implements ASN1Constants {
    private TLVUtil() {
    }

    public static boolean isPrimitive(int n) {
        int n2;
        int n3;
        for (n3 = 3; n3 >= 0 && (n & (n2 = 255 << 8 * n3)) == 0; --n3) {
        }
        n2 = (n & 255 << 8 * n3) >> 8 * n3 & 0xFF;
        boolean bl = (n2 & 0x20) == 0;
        return bl;
    }

    public static int getTagLength(int n) {
        return TLVUtil.getTagAsBytes(n).length;
    }

    public static int getLengthLength(int n) {
        return TLVUtil.getLengthAsBytes(n).length;
    }

    public static byte[] getTagAsBytes(int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = (int)(Math.log(n) / Math.log(256.0)) + 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = 8 * (n2 - i - 1);
            byteArrayOutputStream.write((n & 255 << n3) >> n3);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        switch (TLVUtil.getTagClass(n)) {
            case 1: {
                byArray[0] = (byte)(byArray[0] | 0x40);
                break;
            }
            case 2: {
                byArray[0] = (byte)(byArray[0] | 0x80);
                break;
            }
            case 3: {
                byArray[0] = (byte)(byArray[0] | 0xC0);
            }
        }
        if (!TLVUtil.isPrimitive(n)) {
            byArray[0] = (byte)(byArray[0] | 0x20);
        }
        return byArray;
    }

    public static byte[] getLengthAsBytes(int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n < 128) {
            byteArrayOutputStream.write(n);
        } else {
            int n2 = TLVUtil.log(n, 256);
            byteArrayOutputStream.write(0x80 | n2);
            for (int i = 0; i < n2; ++i) {
                int n3 = 8 * (n2 - i - 1);
                byteArrayOutputStream.write((n & 255 << n3) >> n3);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    static int getTagClass(int n) {
        int n2;
        int n3;
        for (n3 = 3; n3 >= 0 && (n & (n2 = 255 << 8 * n3)) == 0; --n3) {
        }
        n2 = (n & 255 << 8 * n3) >> 8 * n3 & 0xFF;
        switch (n2 & 0xC0) {
            case 0: {
                return 0;
            }
            case 64: {
                return 1;
            }
            case 128: {
                return 2;
            }
        }
        return 3;
    }

    private static int log(int n, int n2) {
        int n3 = 0;
        while (n > 0) {
            n /= n2;
            ++n3;
        }
        return n3;
    }
}

