/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.util;

public final class Hex {
    private static final String HEXCHARS = "0123456789abcdefABCDEF";
    private static final String PRINTABLE = " .,:;'`\"<>()[]{}?/\\!@#$%^&*_-=+|~0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final boolean LEFT = true;
    private static final boolean RIGHT = false;

    private Hex() {
    }

    public static String byteToHexString(byte by) {
        int n = by & 0xFF;
        String string = (n < 16 ? "0" : "") + Integer.toHexString(n);
        return string.toUpperCase();
    }

    public static String shortToHexString(short s) {
        int n = s & 0xFFFF;
        String string = (n < 4096 ? "0" : "") + (n < 256 ? "0" : "") + (n < 16 ? "0" : "") + Integer.toHexString(s);
        if (string.length() > 4) {
            string = string.substring(string.length() - 4, string.length());
        }
        return string.toUpperCase();
    }

    public static String intToHexString(int n) {
        String string = (n < 0x10000000 ? "0" : "") + (n < 0x1000000 ? "0" : "") + (n < 0x100000 ? "0" : "") + (n < 65536 ? "0" : "") + (n < 4096 ? "0" : "") + (n < 256 ? "0" : "") + (n < 16 ? "0" : "") + Integer.toHexString(n);
        return string.toUpperCase();
    }

    public static String bytesToHexString(byte[] byArray) {
        return Hex.bytesToHexString(byArray, 1000);
    }

    public static String bytesToHexString(byte[] byArray, int n) {
        if (byArray == null) {
            return "NULL";
        }
        return Hex.bytesToHexString(byArray, 0, byArray.length, n);
    }

    public static String toHexString(byte[] byArray) {
        return Hex.bytesToHexString(byArray, 0, byArray.length, 1000);
    }

    public static String toHexString(byte[] byArray, int n) {
        return Hex.bytesToHexString(byArray, 0, byArray.length, n);
    }

    public static String bytesToHexString(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            if (i != 0 && i % n3 == 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(Hex.byteToHexString(byArray[n + i]));
        }
        return stringBuffer.toString();
    }

    public static String bytesToHexString(byte[] byArray, int n, int n2) {
        return Hex.bytesToHexString(byArray, n, n2, 1000);
    }

    public static byte hexStringToByte(String string) throws NumberFormatException {
        byte[] byArray = Hex.hexStringToBytes(string);
        if (byArray.length != 1) {
            throw new NumberFormatException();
        }
        return byArray[0];
    }

    public static short hexStringToShort(String string) throws NumberFormatException {
        byte[] byArray = Hex.hexStringToBytes(string);
        if (byArray.length != 2) {
            throw new NumberFormatException();
        }
        return (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
    }

    public static int hexStringToInt(String string) throws NumberFormatException {
        byte[] byArray = Hex.hexStringToBytes(string);
        if (byArray.length != 4) {
            throw new NumberFormatException();
        }
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static byte[] hexStringToBytes(String string) throws NumberFormatException {
        int n;
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (Character.isWhitespace((char)n)) continue;
            if (HEXCHARS.indexOf(n) < 0) {
                throw new NumberFormatException();
            }
            stringBuffer.append((char)n);
        }
        if (stringBuffer.length() % 2 != 0) {
            stringBuffer.insert(0, "0");
        }
        byte[] byArray = new byte[stringBuffer.length() / 2];
        for (n = 0; n < stringBuffer.length(); n += 2) {
            int n2 = Hex.hexDigitToInt(stringBuffer.charAt(n));
            int n3 = Hex.hexDigitToInt(stringBuffer.charAt(n + '\u0001'));
            byArray[n / 2] = (byte)((n2 & 0xFF) << 4 | n3 & 0xFF);
        }
        return byArray;
    }

    static int hexDigitToInt(char c) throws NumberFormatException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new NumberFormatException();
    }

    private static String pad(String string, int n, char c, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        int n3 = n - n2;
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append(c);
        }
        if (bl) {
            return stringBuffer.toString() + string;
        }
        return string + stringBuffer.toString();
    }

    public static String bytesToSpacedHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Hex.byteToHexString(byArray[i]));
            stringBuffer.append(i < byArray.length - 1 ? " " : "");
        }
        return stringBuffer.toString().toUpperCase();
    }

    private static String[] bytesToSpacedHexStrings(byte[] byArray, int n, int n2) {
        byte[][] byArray2 = Hex.split(byArray, n);
        String[] stringArray = new String[byArray2.length];
        for (int i = 0; i < byArray2.length; ++i) {
            stringArray[i] = Hex.bytesToSpacedHexString(byArray2[i]);
            stringArray[i] = Hex.pad(stringArray[i], n2, ' ', false);
        }
        return stringArray;
    }

    public static String bytesToASCIIString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            char c = (char)byArray[i];
            stringBuffer.append(Character.toString(PRINTABLE.indexOf(c) >= 0 ? c : (char)'.'));
        }
        return stringBuffer.toString();
    }

    static String[] bytesToASCIIStrings(byte[] byArray, int n, int n2) {
        byte[][] byArray2 = Hex.split(byArray, n);
        String[] stringArray = new String[byArray2.length];
        for (int i = 0; i < byArray2.length; ++i) {
            stringArray[i] = Hex.bytesToASCIIString(byArray2[i]);
        }
        return stringArray;
    }

    public static byte[][] split(byte[] byArray, int n) {
        int n2 = byArray.length / n;
        int n3 = byArray.length % n;
        byte[][] byArrayArray = new byte[n2 + (n3 > 0 ? 1 : 0)][];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            byArrayArray[i] = new byte[n];
            System.arraycopy(byArray, n4, byArrayArray[i], 0, n);
            n4 += n;
        }
        if (n3 > 0) {
            byArrayArray[n2] = new byte[n3];
            System.arraycopy(byArray, n4, byArrayArray[n2], 0, n3);
        }
        return byArrayArray;
    }

    public static String bytesToPrettyString(byte[] byArray) {
        return Hex.bytesToPrettyString(byArray, 16, true, 4, null, true);
    }

    public static String bytesToPrettyString(byte[] byArray, int n, boolean bl, int n2, String string, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = Hex.bytesToSpacedHexStrings(byArray, n, 3 * n);
        String[] stringArray2 = Hex.bytesToASCIIStrings(byArray, n, n);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (bl) {
                string2 = Integer.toHexString(i * n).toUpperCase();
                stringBuffer.append(Hex.pad(string2, n2, '0', true) + ": ");
            } else {
                string2 = i == 0 ? string : "";
                stringBuffer.append(Hex.pad(string2, n2, ' ', true) + " ");
            }
            stringBuffer.append(stringArray[i]);
            if (bl2) {
                stringBuffer.append(" " + stringArray2[i]);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

