/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import java.math.BigInteger;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.FileInfo;
import net.sf.scuba.util.Hex;

public class ISOFileInfo
extends FileInfo {
    public static final byte FCI_BYTE = 111;
    public static final byte FMD_BYTE = 100;
    public static final byte FCP_BYTE = 98;
    public static final byte DATA_BYTES1 = -128;
    public static final byte DATA_BYTES2 = -127;
    public static final byte FILE_DESCRIPTOR = -126;
    public static final byte FILE_IDENTIFIER = -125;
    public static final byte DF_NAME = -124;
    public static final byte PROP_INFO = -123;
    public static final byte SECURITY_ATTR_PROP = -122;
    public static final byte FCI_EXT = -121;
    public static final byte SHORT_EF = -120;
    public static final byte LCS_BYTE = -118;
    public static final byte SECURITY_ATTR_EXP = -117;
    public static final byte SECURITY_ATTR_COMPACT = -116;
    public static final byte ENV_TEMP_EF = -115;
    public static final byte CHANNEL_SECURITY = -114;
    public static final byte A0 = -96;
    public static final byte A1 = -95;
    public static final byte A2 = -94;
    public static final byte A5 = -91;
    public static final byte AB = -85;
    public static final byte AC = -84;
    byte mainTag = (byte)-1;
    int fileLength = -1;
    int fileLengthFCI = -1;
    byte descriptorByte = (byte)-1;
    byte dataCodingByte = (byte)-1;
    short maxRecordSize = (short)-1;
    short maxRecordsCount = (short)-1;
    short fid = (short)-1;
    byte[] dfName = null;
    byte[] propInfo = null;
    byte[] secAttrProp = null;
    byte[] secAttrExp = null;
    byte[] secAttrCompact = null;
    short fciExt = (short)-1;
    short envTempEF = (short)-1;
    byte shortEF = (byte)-1;
    byte lcsByte = (byte)-1;
    byte channelSecurity = (byte)-1;
    byte[] a0 = null;
    byte[] a1 = null;
    byte[] a2 = null;
    byte[] a5 = null;
    byte[] ab = null;
    byte[] ac = null;

    public ISOFileInfo(byte[] byArray) throws CardServiceException {
        if (byArray.length == 0) {
            return;
        }
        if (byArray[0] != 111 && byArray[0] != 98 && byArray[0] != 100) {
            throw new CardServiceException("Malformed FCI data");
        }
        this.mainTag = byArray[0];
        byte[] byArray2 = new byte[byArray[1]];
        System.arraycopy(byArray, 2, byArray2, 0, byArray[1]);
        byArray = byArray2;
        int n = 0;
        BigInteger bigInteger = null;
        int n2 = 0;
        try {
            while (n < byArray.length) {
                byte by = byArray[n++];
                byte by2 = byArray[n++];
                byte[] byArray3 = new byte[by2];
                System.arraycopy(byArray, n, byArray3, 0, by2);
                n += by2;
                switch (by) {
                    case -128: {
                        bigInteger = new BigInteger(byArray3);
                        bigInteger = bigInteger.abs();
                        this.fileLength = bigInteger.intValue();
                        break;
                    }
                    case -127: {
                        ISOFileInfo.checkLen(by2, 2);
                        bigInteger = new BigInteger(byArray3);
                        this.fileLengthFCI = bigInteger.intValue();
                        break;
                    }
                    case -126: {
                        ISOFileInfo.checkLen(by2, 1, 6);
                        n2 = 0;
                        this.descriptorByte = byArray3[n2++];
                        if (n2 == byArray3.length) break;
                        this.dataCodingByte = byArray3[n2++];
                        if (n2 == byArray3.length) break;
                        if (byArray3.length == 3) {
                            this.maxRecordSize = byArray3[n2++];
                        } else {
                            bigInteger = new BigInteger(new byte[]{byArray3[n2++], byArray3[n2++]});
                            this.maxRecordSize = bigInteger.shortValue();
                        }
                        if (n2 == byArray3.length) break;
                        if (byArray3.length == 5) {
                            this.maxRecordsCount = byArray3[n2++];
                            break;
                        }
                        bigInteger = new BigInteger(new byte[]{byArray3[n2++], byArray3[n2++]});
                        this.maxRecordsCount = bigInteger.shortValue();
                        break;
                    }
                    case -125: {
                        ISOFileInfo.checkLen(by2, 2);
                        bigInteger = new BigInteger(byArray3);
                        this.fid = bigInteger.shortValue();
                        break;
                    }
                    case -124: {
                        ISOFileInfo.checkLen(by2, 0, 16);
                        this.dfName = new byte[byArray3.length];
                        System.arraycopy(byArray3, 0, this.dfName, 0, byArray3.length);
                        break;
                    }
                    case -123: {
                        this.propInfo = new byte[byArray3.length];
                        System.arraycopy(byArray3, 0, this.propInfo, 0, byArray3.length);
                        break;
                    }
                    case -122: {
                        this.secAttrProp = new byte[byArray3.length];
                        System.arraycopy(byArray3, 0, this.secAttrProp, 0, byArray3.length);
                        break;
                    }
                    case -121: {
                        ISOFileInfo.checkLen(by2, 2);
                        bigInteger = new BigInteger(byArray3);
                        this.fciExt = bigInteger.shortValue();
                        break;
                    }
                    case -120: {
                        ISOFileInfo.checkLen(by2, 0, 1);
                        if (by2 == 0) {
                            this.shortEF = 0;
                            break;
                        }
                        this.shortEF = byArray3[0];
                        break;
                    }
                    case -118: {
                        ISOFileInfo.checkLen(by2, 1);
                        this.lcsByte = byArray3[0];
                        break;
                    }
                    case -117: {
                        this.secAttrExp = new byte[byArray3.length];
                        System.arraycopy(byArray3, 0, this.secAttrExp, 0, byArray3.length);
                        break;
                    }
                    case -116: {
                        this.secAttrCompact = new byte[byArray3.length];
                        System.arraycopy(byArray3, 0, this.secAttrCompact, 0, byArray3.length);
                        break;
                    }
                    case -115: {
                        ISOFileInfo.checkLen(by2, 2);
                        bigInteger = new BigInteger(byArray3);
                        this.envTempEF = bigInteger.shortValue();
                        break;
                    }
                    case -114: {
                        ISOFileInfo.checkLen(by2, 1);
                        this.channelSecurity = byArray3[0];
                        break;
                    }
                    case -96: {
                        this.a0 = new byte[byArray3.length];
                        System.arraycopy(byArray3, 0, this.a0, 0, byArray3.length);
                        break;
                    }
                    case -95: {
                        this.a1 = new byte[byArray3.length];
                        System.arraycopy(byArray3, 0, this.a1, 0, byArray3.length);
                        break;
                    }
                    case -94: {
                        this.a2 = new byte[byArray3.length];
                        System.arraycopy(byArray3, 0, this.a2, 0, byArray3.length);
                        break;
                    }
                    case -91: {
                        this.a5 = new byte[byArray3.length];
                        System.arraycopy(byArray3, 0, this.a5, 0, byArray3.length);
                        break;
                    }
                    case -85: {
                        this.ab = new byte[byArray3.length];
                        System.arraycopy(byArray3, 0, this.ab, 0, byArray3.length);
                        break;
                    }
                    case -84: {
                        this.ac = new byte[byArray3.length];
                        System.arraycopy(byArray3, 0, this.ac, 0, byArray3.length);
                        break;
                    }
                    default: {
                        throw new CardServiceException("Malformed FCI: unrecognized tag.");
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CardServiceException("Malformed FCI.");
        }
    }

    private static void checkLen(int n, int n2) throws CardServiceException {
        if (n != n2) {
            throw new CardServiceException("Malformed FCI.");
        }
    }

    private static void checkLen(int n, int n2, int n3) throws CardServiceException {
        if (n < n2 || n > n3) {
            throw new CardServiceException("Malformed FCI.");
        }
    }

    public byte[] getFormatted() {
        byte[] byArray = new byte[]{};
        if (this.mainTag == -1) {
            return byArray;
        }
        byte[] byArray2 = null;
        if (this.fileLength != -1) {
            byArray2 = ISOFileInfo.getArray((byte)-128, Hex.hexStringToBytes(Hex.shortToHexString((short)this.fileLength)));
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.fileLengthFCI != -1) {
            byArray2 = ISOFileInfo.getArray((byte)-127, Hex.hexStringToBytes(Hex.shortToHexString((short)this.fileLengthFCI)));
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.descriptorByte != -1) {
            Object object;
            byte[] byArray3 = new byte[]{this.descriptorByte};
            byte[] byArray4 = new byte[]{};
            if (this.dataCodingByte != -1) {
                byArray4 = new byte[]{this.dataCodingByte};
            }
            byte[] byArray5 = new byte[]{};
            if (this.maxRecordSize != -1) {
                object = null;
                object = this.maxRecordSize <= 256 ? (this.maxRecordsCount == -1 ? (Object)Hex.byteToHexString((byte)this.maxRecordSize) : (Object)Hex.shortToHexString(this.maxRecordSize)) : (Object)Hex.shortToHexString(this.maxRecordSize);
                byArray5 = Hex.hexStringToBytes((String)object);
            }
            object = new byte[]{};
            if (this.maxRecordsCount != -1) {
                String string = null;
                string = this.maxRecordsCount <= 256 ? Hex.byteToHexString((byte)this.maxRecordsCount) : Hex.shortToHexString(this.maxRecordsCount);
                object = Hex.hexStringToBytes(string);
            }
            byArray2 = ISOFileInfo.getArray((byte)-126, ISOFileInfo.catArray(ISOFileInfo.catArray(ISOFileInfo.catArray(byArray3, byArray4), byArray5), (byte[])object));
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.fid != -1) {
            byArray2 = ISOFileInfo.getArray((byte)-125, Hex.hexStringToBytes(Hex.shortToHexString(this.fid)));
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.dfName != null) {
            byArray2 = ISOFileInfo.getArray((byte)-124, this.dfName);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.propInfo != null) {
            byArray2 = ISOFileInfo.getArray((byte)-123, this.propInfo);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.secAttrProp != null) {
            byArray2 = ISOFileInfo.getArray((byte)-122, this.secAttrProp);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.fciExt != -1) {
            byArray2 = ISOFileInfo.getArray((byte)-121, Hex.hexStringToBytes(Hex.shortToHexString(this.fciExt)));
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.shortEF != -1) {
            byte[] byArray6;
            if (this.shortEF == 0) {
                byArray6 = new byte[]{};
            } else {
                byte[] byArray7 = new byte[1];
                byArray6 = byArray7;
                byArray7[0] = this.shortEF;
            }
            byArray2 = ISOFileInfo.getArray((byte)-120, byArray6);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.lcsByte != -1) {
            byArray2 = ISOFileInfo.getArray((byte)-118, new byte[]{this.lcsByte});
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.secAttrExp != null) {
            byArray2 = ISOFileInfo.getArray((byte)-117, this.secAttrExp);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.secAttrCompact != null) {
            byArray2 = ISOFileInfo.getArray((byte)-116, this.secAttrCompact);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.envTempEF != -1) {
            byArray2 = ISOFileInfo.getArray((byte)-115, Hex.hexStringToBytes(Hex.shortToHexString(this.envTempEF)));
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.channelSecurity != -1) {
            byArray2 = ISOFileInfo.getArray((byte)-114, new byte[]{this.channelSecurity});
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.a0 != null) {
            byArray2 = ISOFileInfo.getArray((byte)-96, this.a0);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.a1 != null) {
            byArray2 = ISOFileInfo.getArray((byte)-95, this.a1);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.a2 != null) {
            byArray2 = ISOFileInfo.getArray((byte)-94, this.a2);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.a5 != null) {
            byArray2 = ISOFileInfo.getArray((byte)-91, this.a5);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.ab != null) {
            byArray2 = ISOFileInfo.getArray((byte)-85, this.ab);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        if (this.ac != null) {
            byArray2 = ISOFileInfo.getArray((byte)-84, this.ac);
            byArray = ISOFileInfo.catArray(byArray, byArray2);
        }
        return ISOFileInfo.getArray(this.mainTag, byArray);
    }

    private static byte[] getArray(byte by, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = by;
        byArray2[1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        return byArray2;
    }

    private static byte[] catArray(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public String toString() {
        return "Length: " + this.fileLength + "\n" + "Length FCI: " + this.fileLengthFCI + "\n" + "Desc byte: " + this.descriptorByte + "\n" + "Data byte: " + this.dataCodingByte + "\n" + "Record size: " + this.maxRecordSize + "\n" + "Record count: " + this.maxRecordsCount + "\n" + "FID: " + Hex.shortToHexString(this.fid) + "\n" + "DF name: " + Hex.bytesToHexString(this.dfName) + "\n" + "propInfo: " + Hex.bytesToHexString(this.propInfo) + "\n" + "secAttrProp: " + Hex.bytesToHexString(this.secAttrProp) + "\n" + "secAttrExp: " + Hex.bytesToHexString(this.secAttrExp) + "\n" + "secAttrComp: " + Hex.bytesToHexString(this.secAttrCompact) + "\n" + "FCI ext: " + Hex.shortToHexString(this.fciExt) + "\n" + "EF env temp: " + Hex.shortToHexString(this.envTempEF) + "\n" + "Short EF: " + Hex.byteToHexString(this.shortEF) + "\n" + "LCS byte: " + Hex.byteToHexString(this.lcsByte) + "\n" + "Channel sec: " + Hex.byteToHexString(this.channelSecurity) + "\n" + "a0: " + Hex.bytesToHexString(this.a0) + "\n" + "a1: " + Hex.bytesToHexString(this.a1) + "\n" + "a2: " + Hex.bytesToHexString(this.a2) + "\n" + "a5: " + Hex.bytesToHexString(this.a5) + "\n" + "ab: " + Hex.bytesToHexString(this.ab) + "\n" + "ac: " + Hex.bytesToHexString(this.ac) + "\n";
    }

    @Override
    public short getFID() {
        return this.fid;
    }

    @Override
    public int getFileLength() {
        return this.fileLength;
    }
}

