/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.scuba.tlv.TLVInputState;
import net.sf.scuba.tlv.TLVUtil;

public class TLVInputStream
extends InputStream {
    private static final int MAX_BUFFER_LENGTH = 65535;
    private final InputStream originalInputStream;
    private DataInputStream inputStream;
    private int bufferSize = 0;
    private TLVInputState state;
    private TLVInputState markedState;

    public TLVInputStream(InputStream inputStream) {
        try {
            if (inputStream instanceof BufferedInputStream || inputStream instanceof ByteArrayInputStream) {
                this.bufferSize = inputStream.available();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.originalInputStream = inputStream;
        this.inputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        this.state = new TLVInputState();
        this.markedState = null;
    }

    public int readTag() throws IOException {
        if (!this.state.isAtStartOfTag() && !this.state.isProcessingValue()) {
            throw new IllegalStateException("Not at start of tag");
        }
        int n = -1;
        int n2 = 0;
        int n3 = this.inputStream.readUnsignedByte();
        ++n2;
        while (n3 == 0 || n3 == 255) {
            n3 = this.inputStream.readUnsignedByte();
            ++n2;
        }
        switch (n3 & 0x1F) {
            case 31: {
                n = n3;
                n3 = this.inputStream.readUnsignedByte();
                ++n2;
                while ((n3 & 0x80) == 128) {
                    n <<= 8;
                    n |= n3 & 0x7F;
                    n3 = this.inputStream.readUnsignedByte();
                    ++n2;
                }
                n <<= 8;
                n |= n3 & 0x7F;
                break;
            }
            default: {
                n = n3;
            }
        }
        this.state.setTagProcessed(n, n2);
        return n;
    }

    public int readLength() throws IOException {
        if (!this.state.isAtStartOfLength()) {
            throw new IllegalStateException("Not at start of length");
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.inputStream.readUnsignedByte();
        ++n;
        if ((n3 & 0x80) == 0) {
            n2 = n3;
        } else {
            int n4 = n3 & 0x7F;
            n2 = 0;
            for (int i = 0; i < n4; ++i) {
                n3 = this.inputStream.readUnsignedByte();
                ++n;
                n2 <<= 8;
                n2 |= n3;
            }
        }
        this.state.setLengthProcessed(n2, n);
        return n2;
    }

    public byte[] readValue() throws IOException {
        if (!this.state.isProcessingValue()) {
            throw new IllegalStateException("Not yet processing value!");
        }
        int n = this.state.getLength();
        byte[] byArray = new byte[n];
        this.inputStream.readFully(byArray);
        this.state.updateValueBytesProcessed(n);
        return byArray;
    }

    private long skipValue() throws IOException {
        if (this.state.isAtStartOfTag()) {
            return 0L;
        }
        if (this.state.isAtStartOfLength()) {
            return 0L;
        }
        int n = this.state.getValueBytesLeft();
        return this.skip(n);
    }

    public void skipToTag(int n) throws IOException {
        while (true) {
            int n2 = -1;
            if (!this.state.isAtStartOfTag()) {
                if (this.state.isAtStartOfLength()) {
                    this.readLength();
                    if (TLVUtil.isPrimitive(this.state.getTag())) {
                        this.skipValue();
                    }
                } else if (TLVUtil.isPrimitive(this.state.getTag())) {
                    this.skipValue();
                }
            }
            if ((n2 = this.readTag()) == n) {
                return;
            }
            if (!TLVUtil.isPrimitive(n2)) continue;
            int n3 = this.readLength();
            int n4 = (int)this.skipValue();
            if (n4 < n3) break;
        }
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public int read() throws IOException {
        int n = this.inputStream.read();
        if (n < 0) {
            return -1;
        }
        this.state.updateValueBytesProcessed(1);
        return n;
    }

    @Override
    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.inputStream.skip(l);
        this.state.updateValueBytesProcessed((int)l2);
        return l2;
    }

    @Override
    public synchronized void mark(int n) {
        this.inputStream.mark(n);
        this.markedState = (TLVInputState)this.state.clone();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("mark/reset not supported");
        }
        this.inputStream.reset();
        this.state = this.markedState;
        this.markedState = null;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public String toString() {
        return this.state.toString();
    }
}

