/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.sf.scuba.tlv.ASN1Constants;
import net.sf.scuba.tlv.TLVUtil;
import net.sf.scuba.util.Hex;

class ASN1Util
implements ASN1Constants {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyMMddhhmmss'Z'");

    ASN1Util() {
    }

    static Object interpretPrimitiveValue(int n, byte[] byArray) {
        if (TLVUtil.getTagClass(n) == 0) {
            switch (n) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return byArray;
                }
                case 12: 
                case 19: 
                case 20: 
                case 22: 
                case 26: 
                case 27: 
                case 28: 
                case 30: {
                    return new String(byArray);
                }
                case 23: {
                    try {
                        return SDF.parse(new String(byArray));
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
        return byArray;
    }

    static String tagToString(int n) {
        if (TLVUtil.getTagClass(n) == 0) {
            if (TLVUtil.isPrimitive(n)) {
                switch (n & 0x1F) {
                    case 1: {
                        return "BOOLEAN";
                    }
                    case 2: {
                        return "INTEGER";
                    }
                    case 3: {
                        return "BIT_STRING";
                    }
                    case 4: {
                        return "OCTET_STRING";
                    }
                    case 5: {
                        return "NULL";
                    }
                    case 6: {
                        return "OBJECT_IDENTIFIER";
                    }
                    case 9: {
                        return "REAL";
                    }
                    case 12: {
                        return "UTF_STRING";
                    }
                    case 19: {
                        return "PRINTABLE_STRING";
                    }
                    case 20: {
                        return "T61_STRING";
                    }
                    case 22: {
                        return "IA5_STRING";
                    }
                    case 26: {
                        return "VISIBLE_STRING";
                    }
                    case 27: {
                        return "GENERAL_STRING";
                    }
                    case 28: {
                        return "UNIVERSAL_STRING";
                    }
                    case 30: {
                        return "BMP_STRING";
                    }
                    case 23: {
                        return "UTC_TIME";
                    }
                    case 24: {
                        return "GENERAL_TIME";
                    }
                }
            } else {
                switch (n & 0x1F) {
                    case 10: {
                        return "ENUMERATED";
                    }
                    case 16: {
                        return "SEQUENCE";
                    }
                    case 17: {
                        return "SET";
                    }
                }
            }
        }
        return "'0x" + Hex.intToHexString(n) + "'";
    }
}

