/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.scuba.tlv.TLVOutputState;
import net.sf.scuba.tlv.TLVUtil;

public class TLVOutputStream
extends OutputStream {
    private DataOutputStream outputStream;
    private TLVOutputState state;

    public TLVOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        this.state = new TLVOutputState();
    }

    public void writeTag(int n) throws IOException {
        byte[] byArray = TLVUtil.getTagAsBytes(n);
        if (this.state.canBeWritten()) {
            this.outputStream.write(byArray);
        }
        this.state.setTagProcessed(n);
    }

    public void writeLength(int n) throws IOException {
        byte[] byArray = TLVUtil.getLengthAsBytes(n);
        this.state.setLengthProcessed(n);
        if (this.state.canBeWritten()) {
            this.outputStream.write(byArray);
        }
    }

    public void writeValue(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Cannot write null.");
        }
        if (this.state.isAtStartOfTag()) {
            throw new IllegalStateException("Cannot write value bytes yet. Need to write a tag first.");
        }
        if (this.state.isAtStartOfLength()) {
            this.writeLength(byArray.length);
            this.write(byArray);
        } else {
            this.write(byArray);
            this.state.updatePreviousLength(byArray.length);
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.state.isAtStartOfTag()) {
            throw new IllegalStateException("Cannot write value bytes yet. Need to write a tag first.");
        }
        if (this.state.isAtStartOfLength()) {
            this.state.setDummyLengthProcessed();
        }
        this.state.updateValueBytesProcessed(byArray, n, n2);
        if (this.state.canBeWritten()) {
            this.outputStream.write(byArray, n, n2);
        }
    }

    public void writeValueEnd() throws IOException {
        if (this.state.isAtStartOfLength()) {
            throw new IllegalStateException("Not processing value yet.");
        }
        if (this.state.isAtStartOfTag() && !this.state.isDummyLengthSet()) {
            return;
        }
        byte[] byArray = this.state.getValue();
        int n = byArray.length;
        this.state.updatePreviousLength(n);
        if (this.state.canBeWritten()) {
            byte[] byArray2 = TLVUtil.getLengthAsBytes(n);
            this.outputStream.write(byArray2);
            this.outputStream.write(byArray);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.state.canBeWritten()) {
            throw new IllegalStateException("Cannot close stream yet, illegal TLV state.");
        }
        this.outputStream.close();
    }
}

