/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.data;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.scuba.data.ISOCountry;
import net.sf.scuba.data.TestCountry;
import net.sf.scuba.data.UnicodeCountry;

public abstract class Country {
    private static final Class<?>[] SUB_CLASSES = new Class[]{UnicodeCountry.class, ISOCountry.class, TestCountry.class};

    public static Country getInstance(int n) {
        for (Country country : Country.values()) {
            if (country.valueOf() != n) continue;
            return country;
        }
        throw new IllegalArgumentException("Illegal country code" + Integer.toHexString(n));
    }

    public static Country getInstance(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Illegal country code");
        }
        string = string.trim();
        switch (string.length()) {
            case 2: {
                return Country.fromAlpha2(string);
            }
            case 3: {
                return Country.fromAlpha3(string);
            }
        }
        throw new IllegalArgumentException("Illegal country code " + string);
    }

    public static Country[] values() {
        ArrayList<Country> arrayList = new ArrayList<Country>();
        for (Class<?> clazz : SUB_CLASSES) {
            if (!Country.class.isAssignableFrom(clazz)) continue;
            try {
                Method method = clazz.getMethod("values", new Class[0]);
                Country[] countryArray = (Country[])method.invoke(null, new Object[0]);
                arrayList.addAll(Arrays.asList(countryArray));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Object[] objectArray = new Country[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    public abstract int valueOf();

    public abstract String getName();

    public abstract String getNationality();

    public abstract String toAlpha2Code();

    public abstract String toAlpha3Code();

    private static Country fromAlpha2(String string) {
        for (Country country : Country.values()) {
            if (!country.toAlpha2Code().equals(string)) continue;
            return country;
        }
        throw new IllegalArgumentException("Unknown country code " + string);
    }

    private static Country fromAlpha3(String string) {
        for (Country country : Country.values()) {
            if (!country.toAlpha3Code().equals(string)) continue;
            return country;
        }
        throw new IllegalArgumentException("Unknown country code " + string);
    }
}

