/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import java.util.EventObject;
import net.sf.scuba.smartcards.CardService;

public class CardEvent
extends EventObject {
    private static final long serialVersionUID = -5645277246646615351L;
    public static final int REMOVED = 0;
    public static final int INSERTED = 1;
    private int type;
    private CardService service;

    public CardEvent(int n, CardService cardService) {
        super(cardService);
        this.type = n;
        this.service = cardService;
    }

    public int getType() {
        return this.type;
    }

    public CardService getService() {
        return this.service;
    }

    @Override
    public String toString() {
        switch (this.type) {
            case 0: {
                return "Card removed from " + this.service;
            }
            case 1: {
                return "Card inserted in " + this.service;
            }
        }
        return "CardEvent " + this.service;
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!object.getClass().equals(this.getClass())) {
                return false;
            }
            CardEvent cardEvent = (CardEvent)object;
            return this.type == cardEvent.type && this.service.equals(cardEvent.service);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return 5 * this.service.hashCode() + 7 * this.type;
    }
}

