/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

public class CardServiceException
extends Exception {
    private static final long serialVersionUID = 4489156194716970879L;
    public static final int SW_NONE = -1;
    private int sw = -1;

    public static long getSerialVersionUID() {
        return 4489156194716970879L;
    }

    public CardServiceException(String string) {
        super(string);
    }

    public CardServiceException(String string, int n) {
        super(string);
        this.sw = n;
    }

    @Override
    public String getMessage() {
        if (this.sw == -1) {
            return super.getMessage();
        }
        return super.getMessage() + " (SW = 0x" + Integer.toHexString(this.sw).toUpperCase() + ": " + CardServiceException.statusWordToString((short)this.sw) + ")";
    }

    public int getSW() {
        return this.sw;
    }

    private static String statusWordToString(short s) {
        switch (s) {
            case 25218: {
                return "END OF FILE";
            }
            case 25223: {
                return "LESS DATA RESPONDED THAN REQUESTED";
            }
            case 26368: {
                return "WRONG LENGTH";
            }
            case 26753: {
                return "LOGICAL CHANNEL NOT SUPPORTED";
            }
            case 26754: {
                return "SECURE MESSAGING NOT SUPPORTED";
            }
            case 26755: {
                return "LAST COMMAND EXPECTED";
            }
            case 27010: {
                return "SECURITY STATUS NOT SATISFIED";
            }
            case 27011: {
                return "FILE INVALID";
            }
            case 27012: {
                return "DATA INVALID";
            }
            case 27013: {
                return "CONDITIONS NOT SATISFIED";
            }
            case 27014: {
                return "COMMAND NOT ALLOWED";
            }
            case 27015: {
                return "EXPECTED SM DATA OBJECTS MISSING";
            }
            case 27016: {
                return "SM DATA OBJECTS INCORRECT";
            }
            case 27033: {
                return "APPLET SELECT FAILED";
            }
            case 27073: {
                return "KEY USAGE ERROR";
            }
            case 27264: {
                return "WRONG DATA or FILEHEADER INCONSISTENT";
            }
            case 27265: {
                return "FUNC NOT SUPPORTED";
            }
            case 27266: {
                return "FILE NOT FOUND";
            }
            case 27267: {
                return "RECORD NOT FOUND";
            }
            case 27268: {
                return "OUT OF MEMORY or FILE FULL";
            }
            case 27270: {
                return "INCORRECT P1P2";
            }
            case 27272: {
                return "KEY NOT FOUND";
            }
            case 27392: {
                return "WRONG P1P2";
            }
            case 27904: {
                return "INS NOT SUPPORTED";
            }
            case 28160: {
                return "CLA NOT SUPPORTED";
            }
            case 28416: {
                return "UNKNOWN";
            }
            case 28671: {
                return "CARD TERMINATED";
            }
            case -28672: {
                return "NO ERROR";
            }
        }
        if ((s & 0xFF00) == 24832) {
            return "BYTES REMAINING " + Integer.toString(s & 0xFF);
        }
        if ((s & 0xFF00) == 27648) {
            return "CORRECT LENGTH " + Integer.toString(s & 0xFF);
        }
        if ((s & 0xFFF0) == 25536) {
            return "NON VOLATILE MEMORY CHANGED COUNT " + Integer.toString(s & 0xF);
        }
        return "Unknown";
    }
}

