/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;

public class WrappingCardService
extends CardService {
    private static final long serialVersionUID = -1872209495542386286L;
    private CardService service;
    private APDUWrapper wrapper;
    private boolean enabled;

    public WrappingCardService(CardService cardService, APDUWrapper aPDUWrapper) {
        this.service = cardService;
        this.wrapper = aPDUWrapper;
    }

    @Override
    public void open() throws CardServiceException {
        this.service.open();
    }

    @Override
    public boolean isOpen() {
        return this.service.isOpen();
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU commandAPDU) throws CardServiceException {
        if (this.isEnabled()) {
            ResponseAPDU responseAPDU = this.service.transmit(this.wrapper.wrap(commandAPDU));
            return this.wrapper.unwrap(responseAPDU, responseAPDU.getBytes().length);
        }
        return this.service.transmit(commandAPDU);
    }

    @Override
    public byte[] getATR() throws CardServiceException {
        return this.service.getATR();
    }

    @Override
    public void close() {
        this.service.close();
    }

    public void enable() {
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        this.enabled = false;
    }
}

