/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;

public class WrappingCardService
extends CardService {
    private static final long serialVersionUID = -1872209495542386286L;
    private CardService service;
    private APDUWrapper wrapper;
    private boolean enabled;

    public WrappingCardService(CardService service, APDUWrapper wrapper) {
        this.service = service;
        this.wrapper = wrapper;
    }

    public void open() throws CardServiceException {
        this.service.open();
    }

    public boolean isOpen() {
        return this.service.isOpen();
    }

    public ResponseAPDU transmit(CommandAPDU capdu) throws CardServiceException {
        if (this.isEnabled()) {
            ResponseAPDU rapdu = this.service.transmit(this.wrapper.wrap(capdu));
            return this.wrapper.unwrap(rapdu);
        }
        return this.service.transmit(capdu);
    }

    public byte[] getATR() throws CardServiceException {
        return this.service.getATR();
    }

    public void close() {
        this.service.close();
    }

    public void enable() {
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        this.enabled = false;
    }
}

